"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuditdFileExample = void 0;
var _react = _interopRequireDefault(require("react"));
var _timeline = require("../../../../common/demo_data/timeline");
var _generic_row_renderer = require("../../timeline/body/renderers/auditd/generic_row_renderer");
var _translations = require("../../timeline/body/renderers/auditd/translations");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AuditdFileExampleComponent = () => {
  const auditdFileRowRenderer = (0, _generic_row_renderer.createGenericFileRowRenderer)({
    actionName: 'opened-file',
    text: `${_translations.OPENED_FILE} ${_translations.USING}`
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, auditdFileRowRenderer.renderRow({
    data: _timeline.demoTimelineData[27].ecs,
    scopeId: _constants.ROW_RENDERER_BROWSER_EXAMPLE_TIMELINE_ID
  }));
};
const AuditdFileExample = exports.AuditdFileExample = /*#__PURE__*/_react.default.memo(AuditdFileExampleComponent);