"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleMigrationsStorage = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/kibana-utils-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const storages = {
  local: new _public.Storage(localStorage),
  session: new _public.Storage(sessionStorage)
};
class RuleMigrationsStorage {
  constructor(objectName, options) {
    var _this$options$storage, _this$options;
    (0, _defineProperty2.default)(this, "storage", void 0);
    (0, _defineProperty2.default)(this, "key", void 0);
    (0, _defineProperty2.default)(this, "get", () => this.storage.get(this.key));
    (0, _defineProperty2.default)(this, "set", value => this.storage.set(this.key, value));
    (0, _defineProperty2.default)(this, "remove", () => this.storage.remove(this.key));
    this.objectName = objectName;
    this.options = options;
    this.storage = storages[(_this$options$storage = (_this$options = this.options) === null || _this$options === void 0 ? void 0 : _this$options.storageType) !== null && _this$options$storage !== void 0 ? _this$options$storage : 'local'];
    this.key = this.getKey();
  }
  getKey(spaceId = 'default') {
    var _this$options2;
    if ((_this$options2 = this.options) !== null && _this$options2 !== void 0 && _this$options2.customKey) {
      return this.options.customKey;
    }
    return `siem_migrations.rules.${this.objectName}.${spaceId}`;
  }
  setSpaceId(spaceId) {
    this.key = this.getKey(spaceId);
  }
}
exports.RuleMigrationsStorage = RuleMigrationsStorage;