"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.siemMigrationsLinks = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/security-solution-features/constants");
var _constants2 = require("../../common/constants");
var _siem_migrations = require("../common/icons/siem_migrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const siemMigrationsLinks = exports.siemMigrationsLinks = {
  id: _constants2.SecurityPageName.siemMigrationsRules,
  title: _i18n.i18n.translate('xpack.securitySolution.appLinks.automaticMigrationRules.title', {
    defaultMessage: 'Automatic migrations'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.appLinks.siemMigrationsRules.description', {
    defaultMessage: 'Our generative AI powered Automatic migration tool automates some of the most time consuming migrations tasks and processes.'
  }),
  landingIcon: _siem_migrations.SiemMigrationsIcon,
  path: _constants2.SIEM_MIGRATIONS_RULES_PATH,
  capabilities: [[`${_constants2.SECURITY_FEATURE_ID}.show`, `${_constants.SIEM_MIGRATIONS_FEATURE_ID}.all`]],
  skipUrlState: true,
  hideTimeline: true,
  hideWhenExperimentalKey: 'siemMigrationsDisabled'
};