"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyArtifactsEmptyUnassigned = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _policy_hooks = require("../../policy_hooks");
var _use_policy_artifacts_empty_hooks = require("./use_policy_artifacts_empty_hooks");
var _user_privileges = require("../../../../../../common/components/user_privileges");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyArtifactsEmptyUnassigned = exports.PolicyArtifactsEmptyUnassigned = /*#__PURE__*/(0, _react.memo)(({
  policyId,
  policyName,
  listId,
  labels,
  canWriteArtifact = false,
  getPolicyArtifactsPath,
  getArtifactPath
}) => {
  const {
    canCreateArtifactsByPolicy
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const {
    onClickHandler,
    toRouteUrl
  } = (0, _use_policy_artifacts_empty_hooks.useGetLinkTo)(policyId, policyName, getPolicyArtifactsPath, getArtifactPath);
  const navigateCallback = (0, _policy_hooks.usePolicyDetailsArtifactsNavigateCallback)(listId);
  const onClickPrimaryButtonHandler = (0, _react.useCallback)(() => navigateCallback({
    show: 'list'
  }), [navigateCallback]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    iconType: "plusInCircle",
    "data-test-subj": "policy-artifacts-empty-unassigned",
    color: "subdued",
    title: /*#__PURE__*/_react.default.createElement("h2", null, labels.emptyUnassignedTitle),
    body: canWriteArtifact ? labels.emptyUnassignedMessage(policyName) : labels.emptyUnassignedNoPrivilegesMessage(policyName),
    actions: [...(canCreateArtifactsByPolicy && canWriteArtifact ? [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      onClick: onClickPrimaryButtonHandler,
      "data-test-subj": "unassigned-assign-artifacts-button"
    }, labels.emptyUnassignedPrimaryActionButtonTitle)] : []), canWriteArtifact ?
    /*#__PURE__*/
    // eslint-disable-next-line @elastic/eui/href-or-on-click
    _react.default.createElement(_eui.EuiLink, {
      onClick: onClickHandler,
      href: toRouteUrl,
      "data-test-subj": "unassigned-manage-artifacts-button"
    }, labels.emptyUnassignedSecondaryActionButtonTitle) : null]
  });
});
PolicyArtifactsEmptyUnassigned.displayName = 'PolicyArtifactsEmptyUnassigned';