"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostIsolationExceptionsAccess = void 0;
var _react = require("react");
var _check_artifact_has_data = require("../../services/exceptions_list/check_artifact_has_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHostIsolationExceptionsAccess = (canAccessHostIsolationExceptions, canReadHostIsolationExceptions, getApiClient) => {
  const [hasAccess, setHasAccess] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    (async () => {
      // Host isolation exceptions is a paid feature and therefore:
      // canAccessHostIsolationExceptions signifies if the user has required license to access the feature.
      // canReadHostIsolationExceptions, however, is a privilege that allows the user to read and delete the data even if the license is not sufficient (downgrade scenario).
      // In such cases, the tab should be visible only if there is existing data.
      if (canAccessHostIsolationExceptions) {
        setHasAccess(true);
      } else if (canReadHostIsolationExceptions) {
        const result = await (0, _check_artifact_has_data.checkArtifactHasData)(getApiClient());
        setHasAccess(result);
      } else {
        setHasAccess(false);
      }
    })();
  }, [canAccessHostIsolationExceptions, canReadHostIsolationExceptions, getApiClient]);
  return {
    hasAccessToHostIsolationExceptions: !!hasAccess,
    isHostIsolationExceptionsAccessLoading: hasAccess === null
  };
};
exports.useHostIsolationExceptionsAccess = useHostIsolationExceptionsAccess;