"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStoredInputHistory = exports.useSaveInputHistoryToStorage = void 0;
var _react = require("react");
var _kibana = require("../../../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COMMAND_INPUT_HISTORY_KEY = 'commandInputHistory';

/**
 * The current version of the input history offline storage.
 *
 * NOTE:  Changes to this value will likely require some migration to be added
 *        to `migrateHistoryData()` down below.
 */
const CURRENT_VERSION = 2;
const getDefaultInputHistoryStorage = () => {
  return {
    version: CURRENT_VERSION,
    data: []
  };
};
const useStoredInputHistory = storagePrefix => {
  const {
    storage
  } = (0, _kibana.useKibana)().services;
  return (0, _react.useMemo)(() => {
    if (storagePrefix) {
      var _ref;
      const storedData = (_ref = storage.get(`${storagePrefix}.${COMMAND_INPUT_HISTORY_KEY}`)) !== null && _ref !== void 0 ? _ref : getDefaultInputHistoryStorage();
      if (storedData.version !== CURRENT_VERSION) {
        migrateHistoryData(storedData);
      }
      return storedData.data;
    }
    return [];
  }, [storage, storagePrefix]);
};
exports.useStoredInputHistory = useStoredInputHistory;
const useSaveInputHistoryToStorage = storagePrefix => {
  const {
    storage
  } = (0, _kibana.useKibana)().services;
  return (0, _react.useCallback)(data => {
    if (storagePrefix) {
      const update = {
        version: CURRENT_VERSION,
        data
      };
      storage.set(`${storagePrefix}.${COMMAND_INPUT_HISTORY_KEY}`, update);
    }
  }, [storage, storagePrefix]);
};
exports.useSaveInputHistoryToStorage = useSaveInputHistoryToStorage;
const migrateHistoryData = storedData => {
  const {
    data,
    version
  } = storedData;
  for (const historyItem of data) {
    // -------------------------------------------
    // V2:
    //    - adds `display` property
    // -------------------------------------------
    if (version < 2) {
      historyItem.display = historyItem.input;
    }
  }
  storedData.version = CURRENT_VERSION;
};