"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CardHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _date_field_value = require("./date_field_value");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _card_actions_flex_item = require("./card_actions_flex_item");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiFlexItemSmallBottomMargin = (0, _styled.default)(_eui.EuiFlexItem)`
  margin-bottom: ${({
  theme
}) => theme.euiTheme.size.xs} !important;
`;
const CardHeader = exports.CardHeader = /*#__PURE__*/(0, _react.memo)(({
  name,
  createdDate,
  updatedDate,
  actions,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "flexStart",
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(StyledEuiFlexItemSmallBottomMargin, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", {
    "data-test-subj": getTestId('title')
  }, name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_date_field_value.DateFieldValue, {
    date: updatedDate,
    type: "update",
    "data-test-subj": getTestId('updated')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_date_field_value.DateFieldValue, {
    date: createdDate,
    type: "create",
    "data-test-subj": getTestId('created')
  })))))), /*#__PURE__*/_react.default.createElement(_card_actions_flex_item.CardActionsFlexItem, {
    actions: actions,
    "data-test-subj": getTestId('actions')
  }));
});
CardHeader.displayName = 'CardHeader';