"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOpenGenericEntityDetailsLeftPanel = void 0;
var _use_has_misconfigurations = require("@kbn/cloud-security-posture/src/hooks/use_has_misconfigurations");
var _use_has_vulnerabilities = require("@kbn/cloud-security-posture/src/hooks/use_has_vulnerabilities");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _use_non_closed_alerts = require("../../../../cloud_security_posture/hooks/use_non_closed_alerts");
var _types = require("../../../../overview/components/detection_response/alerts_by_status/types");
var _generic_details_left = require("../../generic_details_left");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useOpenGenericEntityDetailsLeftPanel = ({
  insightsField,
  insightsValue,
  entityDocId,
  scopeId
}) => {
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    hasMisconfigurationFindings
  } = (0, _use_has_misconfigurations.useHasMisconfigurations)(insightsField, insightsValue);
  const {
    hasVulnerabilitiesFindings
  } = (0, _use_has_vulnerabilities.useHasVulnerabilities)(insightsField, insightsValue);
  const {
    to,
    from
  } = (0, _use_global_time.useGlobalTime)();
  const {
    hasNonClosedAlerts
  } = (0, _use_non_closed_alerts.useNonClosedAlerts)({
    field: insightsField,
    value: insightsValue,
    to,
    from,
    queryId: `${_types.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID}-generic-entity-alerts`
  });
  const openGenericEntityDetails = path => {
    return openLeftPanel({
      id: _generic_details_left.GenericEntityDetailsPanelKey,
      params: {
        entityDocId,
        field: insightsField,
        value: insightsValue,
        scopeId,
        isRiskScoreExist: false,
        hasMisconfigurationFindings,
        hasVulnerabilitiesFindings,
        hasNonClosedAlerts,
        path
      }
    });
  };
  return {
    openGenericEntityDetails
  };
};
exports.useOpenGenericEntityDetailsLeftPanel = useOpenGenericEntityDetailsLeftPanel;