"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useListDetailsView = void 0;
var _react = require("react");
var _securitysolutionExceptionListComponents = require("@kbn/securitysolution-exception-list-components");
var _securitysolutionListHooks = require("@kbn/securitysolution-list-hooks");
var _lodash = require("lodash");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _constants = require("../../../../common/endpoint/service/artifacts/constants");
var _user_info = require("../../../detections/components/user_info");
var _constants2 = require("../../../../common/constants");
var _kibana = require("../../../common/lib/kibana");
var _api = require("../../api");
var _list = require("../../utils/list.utils");
var i18n = _interopRequireWildcard(require("../../translations"));
var _use_fetch_rule_by_id_query = require("../../../detection_engine/rule_management/api/hooks/use_fetch_rule_by_id_query");
var _use_endpoint_exceptions_capability = require("../use_endpoint_exceptions_capability");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const exceptionReferenceModalInitialState = {
  contentText: '',
  rulesReferences: [],
  isLoading: false,
  listId: '',
  listNamespaceType: 'single'
};
const useListDetailsView = exceptionListId => {
  const toasts = (0, _kibana.useToasts)();
  const {
    services
  } = (0, _kibana.useKibana)();
  const {
    http,
    notifications
  } = services;
  const {
    navigateToApp
  } = services.application;
  const {
    exportExceptionList,
    deleteExceptionList,
    duplicateExceptionList
  } = (0, _securitysolutionListHooks.useApi)(http);
  const [{
    loading: userInfoLoading,
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const canWriteEndpointExceptions = (0, _use_endpoint_exceptions_capability.useEndpointExceptionsCapability)('crudEndpointExceptions');
  const canUserWriteCurrentList = exceptionListId === _securitysolutionListConstants.ENDPOINT_LIST_ID ? canWriteEndpointExceptions : canUserCRUD;
  const [isLoading, setIsLoading] = (0, _react.useState)();
  const [showManageButtonLoader, setShowManageButtonLoader] = (0, _react.useState)(false);
  const [list, setList] = (0, _react.useState)();
  const [invalidListId, setInvalidListId] = (0, _react.useState)(false);
  const [linkedRules, setLinkedRules] = (0, _react.useState)([]);
  const [newLinkedRules, setNewLinkedRules] = (0, _react.useState)([]);
  const [canUserEditList, setCanUserEditList] = (0, _react.useState)(true);
  const [viewerStatus, setViewerStatus] = (0, _react.useState)('');
  const [exportedList, setExportedList] = (0, _react.useState)();
  const [showReferenceErrorModal, setShowReferenceErrorModal] = (0, _react.useState)(false);
  const [referenceModalState, setReferenceModalState] = (0, _react.useState)(exceptionReferenceModalInitialState);
  const [disableManageButton, setDisableManageButton] = (0, _react.useState)(true);
  const [refreshExceptions, setRefreshExceptions] = (0, _react.useState)(false);
  const invalidateFetchRuleByIdQuery = (0, _use_fetch_rule_by_id_query.useInvalidateFetchRuleByIdQuery)();
  const headerBackOptions = (0, _react.useMemo)(() => ({
    pageId: _constants2.SecurityPageName.exceptions,
    path: '',
    onNavigate: () => {
      navigateToApp(_constants2.APP_UI_ID, {
        deepLinkId: _constants2.SecurityPageName.exceptions,
        path: ''
      });
    }
  }), [navigateToApp]);
  const handleErrorStatus = (0, _react.useCallback)((error, newViewerStatue, errorTitle, errorDescription) => {
    toasts === null || toasts === void 0 ? void 0 : toasts.addError(error, {
      title: errorTitle !== null && errorTitle !== void 0 ? errorTitle : '',
      toastMessage: errorDescription !== null && errorDescription !== void 0 ? errorDescription : ''
    });
    setViewerStatus(newViewerStatue !== null && newViewerStatue !== void 0 ? newViewerStatue : '');
  }, [toasts]);
  const initializeListRules = (0, _react.useCallback)(async result => {
    if (result) {
      const listRules = await (0, _api.getListRules)(result.list_id);
      setLinkedRules(listRules);
    }
  }, []);
  const initializeList = (0, _react.useCallback)(async () => {
    try {
      if (_constants.ALL_ENDPOINT_ARTIFACT_LIST_IDS.includes(exceptionListId)) return setInvalidListId(true);
      setIsLoading(true);
      const result = await (0, _api.getListById)({
        id: exceptionListId,
        http
      });
      if (!result || !(0, _list.isAnExceptionListItem)(result)) {
        setIsLoading(false);
        return setInvalidListId(true);
      }
      setList(result);
      await initializeListRules(result);
      setIsLoading(false);
      setInvalidListId(false);
      if ((0, _list.checkIfListCannotBeEdited)(result)) return setCanUserEditList(false);
    } catch (error) {
      handleErrorStatus(error, _securitysolutionExceptionListComponents.ViewerStatus.ERROR, i18n.EXCEPTION_ERROR_TITLE, i18n.EXCEPTION_ERROR_DESCRIPTION);
    }
  }, [exceptionListId, http, initializeListRules, handleErrorStatus]);
  (0, _react.useEffect)(() => {
    initializeList();
  }, [initializeList]);
  const [showManageRulesFlyout, setShowManageRulesFlyout] = (0, _react.useState)(false);
  const onEditListDetails = (0, _react.useCallback)(async listDetails => {
    try {
      var _listDetails$descript;
      if (list) await (0, _api.updateList)({
        http,
        list: {
          id: list.id,
          list_id: exceptionListId,
          type: list.type,
          name: listDetails.name,
          description: (_listDetails$descript = listDetails.description) !== null && _listDetails$descript !== void 0 ? _listDetails$descript : '',
          namespace_type: list.namespace_type
        }
      });
    } catch (error) {
      handleErrorStatus(error);
    }
  }, [exceptionListId, handleErrorStatus, http, list]);
  const onExportList = (0, _react.useCallback)(async includeExpiredExceptions => {
    try {
      if (!list) return;
      await exportExceptionList({
        id: list.id,
        listId: list.list_id,
        includeExpiredExceptions,
        namespaceType: list.namespace_type,
        onError: error => handleErrorStatus(error),
        onSuccess: blob => {
          setExportedList(blob);
          toasts === null || toasts === void 0 ? void 0 : toasts.addSuccess(i18n.EXCEPTION_LIST_EXPORTED_SUCCESSFULLY(list.name));
        }
      });
    } catch (error) {
      handleErrorStatus(error, undefined, i18n.EXCEPTION_EXPORT_ERROR, i18n.EXCEPTION_EXPORT_ERROR_DESCRIPTION);
    }
  }, [list, exportExceptionList, handleErrorStatus, toasts]);
  const onDuplicateList = (0, _react.useCallback)(async includeExpiredExceptions => {
    try {
      if (!list) return;
      await duplicateExceptionList({
        listId: list.list_id,
        includeExpiredExceptions,
        namespaceType: list.namespace_type,
        onError: error => handleErrorStatus(error),
        onSuccess: newList => {
          toasts === null || toasts === void 0 ? void 0 : toasts.addSuccess(i18n.EXCEPTION_LIST_DUPLICATED_SUCCESSFULLY(list.name));
          navigateToApp(_constants2.APP_UI_ID, {
            deepLinkId: _constants2.SecurityPageName.exceptions,
            path: `/details/${newList.list_id}`
          });
        }
      });
    } catch (error) {
      handleErrorStatus(error, undefined, i18n.EXCEPTION_DUPLICATE_ERROR, i18n.EXCEPTION_DUPLICATE_ERROR_DESCRIPTION);
    }
  }, [list, duplicateExceptionList, handleErrorStatus, toasts, navigateToApp]);
  const handleOnDownload = (0, _react.useCallback)(() => {
    setExportedList(undefined);
  }, []);

  // #region DeleteList

  const handleDeleteSuccess = (0, _react.useCallback)(listId => () => {
    notifications.toasts.addSuccess({
      title: i18n.exceptionDeleteSuccessMessage(listId !== null && listId !== void 0 ? listId : referenceModalState.listId)
    });
  }, [notifications.toasts, referenceModalState.listId]);
  const handleDeleteError = (0, _react.useCallback)(err => {
    handleErrorStatus(err);
  }, [handleErrorStatus]);
  const onDeleteList = (0, _react.useCallback)(async () => {
    try {
      if (!list) return;
      await deleteExceptionList({
        id: list.id,
        namespaceType: list.namespace_type,
        onError: handleDeleteError,
        onSuccess: handleDeleteSuccess
      });
    } catch (error) {
      handleErrorStatus(error);
    } finally {
      setReferenceModalState(exceptionReferenceModalInitialState);
      setShowReferenceErrorModal(false);
      navigateToApp(_constants2.APP_UI_ID, {
        deepLinkId: _constants2.SecurityPageName.exceptions,
        path: ''
      });
    }
  }, [list, deleteExceptionList, handleDeleteError, handleDeleteSuccess, handleErrorStatus, navigateToApp]);
  const handleDelete = (0, _react.useCallback)(() => {
    try {
      if (!list) return;
      setReferenceModalState({
        contentText: linkedRules.length ? i18n.referenceErrorMessage(linkedRules.length) : i18n.defaultDeleteListMessage(list.name),
        rulesReferences: linkedRules.map(({
          name
        }) => name),
        isLoading: true,
        listId: list.list_id,
        listNamespaceType: list.namespace_type
      });
      setShowReferenceErrorModal(true);
    } catch (error) {
      handleErrorStatus(error);
    }
  }, [handleErrorStatus, linkedRules, list]);
  const handleCloseReferenceErrorModal = (0, _react.useCallback)(() => {
    setShowReferenceErrorModal(false);
    setReferenceModalState({
      contentText: '',
      rulesReferences: [],
      isLoading: false,
      listId: '',
      listNamespaceType: 'single'
    });
  }, []);
  const handleReferenceDelete = (0, _react.useCallback)(async () => {
    try {
      await (0, _api.unlinkListFromRules)({
        rules: linkedRules,
        listId: exceptionListId
      });
      onDeleteList();
    } catch (err) {
      handleErrorStatus(err);
    }
  }, [exceptionListId, linkedRules, handleErrorStatus, onDeleteList]);

  // #endregion

  // #region Manage Rules

  const resetManageRulesAfterSaving = (0, _react.useCallback)(() => {
    setLinkedRules(newLinkedRules);
    setNewLinkedRules(newLinkedRules);
    setShowManageRulesFlyout(false);
    setShowManageButtonLoader(false);
    setDisableManageButton(true);
  }, [newLinkedRules]);
  const onManageRules = (0, _react.useCallback)(() => {
    setShowManageRulesFlyout(true);
  }, []);
  const getRulesToAdd = (0, _react.useCallback)(() => {
    return newLinkedRules.filter(rule => !linkedRules.includes(rule));
  }, [linkedRules, newLinkedRules]);
  const getRulesToRemove = (0, _react.useCallback)(() => {
    return linkedRules.filter(rule => !newLinkedRules.includes(rule));
  }, [linkedRules, newLinkedRules]);
  const onRuleSelectionChange = (0, _react.useCallback)(value => {
    setNewLinkedRules(value);
    setDisableManageButton(false);
  }, []);
  const onSaveManageRules = (0, _react.useCallback)(async () => {
    try {
      if (!list) return setShowManageRulesFlyout(false);
      setShowManageButtonLoader(true);
      const rulesToAdd = getRulesToAdd();
      const rulesToRemove = getRulesToRemove();
      if (!rulesToAdd.length && !rulesToRemove.length || (0, _lodash.isEqual)(rulesToAdd, rulesToRemove)) return resetManageRulesAfterSaving();
      Promise.all([(0, _api.unlinkListFromRules)({
        rules: rulesToRemove,
        listId: exceptionListId
      }), (0, _api.linkListToRules)({
        rules: rulesToAdd,
        listId: exceptionListId,
        id: list.id,
        listType: list.type,
        listNamespaceType: list.namespace_type
      })]).then(() => {
        setRefreshExceptions(true);
        resetManageRulesAfterSaving();
      }).then(() => setRefreshExceptions(false)).then(() => invalidateFetchRuleByIdQuery()).catch(error => {
        handleErrorStatus(error, undefined, i18n.EXCEPTION_MANAGE_RULES_ERROR, i18n.EXCEPTION_MANAGE_RULES_ERROR_DESCRIPTION);
        setShowManageButtonLoader(false);
      }).finally(() => {
        initializeList();
      });
    } catch (err) {
      handleErrorStatus(err);
    }
  }, [list, getRulesToAdd, getRulesToRemove, resetManageRulesAfterSaving, exceptionListId, invalidateFetchRuleByIdQuery, handleErrorStatus, initializeList]);
  const onCancelManageRules = (0, _react.useCallback)(() => {
    setShowManageRulesFlyout(false);
  }, []);

  // #endregion

  return {
    isLoading: isLoading || userInfoLoading,
    invalidListId,
    isReadOnly: !canUserWriteCurrentList,
    list,
    listName: list === null || list === void 0 ? void 0 : list.name,
    listDescription: list === null || list === void 0 ? void 0 : list.description,
    listId: exceptionListId,
    canUserEditList,
    linkedRules,
    exportedList,
    handleOnDownload,
    viewerStatus,
    showManageRulesFlyout,
    headerBackOptions,
    referenceModalState,
    showReferenceErrorModal,
    showManageButtonLoader,
    refreshExceptions,
    disableManageButton,
    handleDelete,
    onDuplicateList,
    onEditListDetails,
    onExportList,
    onDeleteList,
    onManageRules,
    onSaveManageRules,
    onCancelManageRules,
    onRuleSelectionChange,
    handleCloseReferenceErrorModal,
    handleReferenceDelete
  };
};
exports.useListDetailsView = useListDetailsView;