"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedUserMonitoringOnboardingPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _add_data_source = require("./components/add_data_source");
var _information_light = _interopRequireDefault(require("../../../common/images/information_light.png"));
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrivilegedUserMonitoringOnboardingPanel = ({
  onComplete
}) => {
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    "data-test-subj": "privilegedUserMonitoringOnboardingPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "xl",
    color: "subdued",
    hasShadow: false,
    hasBorder: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween",
    gutterSize: "xl",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    hasBorder: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'm',
    alignItems: 'center'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.pageTitle",
    defaultMessage: "Privileged user monitoring"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    size: 'm',
    label: _i18n.i18n.translate('xpack.securitySolution.privilegedUserMonitoring.onboarding.betaStatus', {
      defaultMessage: 'TECHNICAL PREVIEW'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.pageDescription",
    defaultMessage: "Gain visibility into privileged user activity to analyze account usage, track access events, and spot potential risks. By continuously monitoring high-risk users and identifying anomalous privileged behaviors, you can detect potential threats, such as unauthorized access or lateral movement, before they escalate."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "documentation",
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.learnMore.label",
    defaultMessage: "Want to learn more?"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    external: true,
    "data-test-subj": "learnMoreLink",
    href: docLinks === null || docLinks === void 0 ? void 0 : docLinks.links.securitySolution.entityAnalytics.privilegedUserMonitoring,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.docLink.description",
    defaultMessage: "Check our documentation"
  })))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    src: _information_light.default,
    hasShadow: false,
    alt: _i18n.i18n.translate('xpack.securitySolution.privilegedUserMonitoring.onboarding.dashboardIllustrationAltText', {
      defaultMessage: 'Privileged user monitoring dashboard illustration'
    }),
    size: "l"
  })))), /*#__PURE__*/_react.default.createElement(_add_data_source.AddDataSourcePanel, {
    onComplete: onComplete
  }));
};
exports.PrivilegedUserMonitoringOnboardingPanel = PrivilegedUserMonitoringOnboardingPanel;