"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexImportManageDataSource = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactHooks = require("@kbn/react-hooks");
var _select_index_modal = require("../privileged_user_monitoring_onboarding/components/select_index_modal");
var _use_fetch_monitored_indices = require("../privileged_user_monitoring_onboarding/hooks/use_fetch_monitored_indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexImportManageDataSource = ({
  setAddDataSourceResult
}) => {
  const [isIndexModalOpen, {
    on: showIndexModal,
    off: hideIndexModal
  }] = (0, _reactHooks.useBoolean)(false);
  const {
    data: datasources = [],
    isFetching,
    refetch
  } = (0, _use_fetch_monitored_indices.useFetchMonitoredIndices)();
  const monitoredDataSource = datasources[0];
  const monitoredIndices = monitoredDataSource !== null && monitoredDataSource !== void 0 && monitoredDataSource.indexPattern ? monitoredDataSource.indexPattern.split(',') : [];
  const onImport = async () => {
    hideIndexModal();
    setAddDataSourceResult({
      successful: true,
      userCount: 0
    });
    await refetch();
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "indexOpen"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.manageDataSources.indices",
    defaultMessage: "Indices"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.manageDataSources.indices.infoText",
    defaultMessage: "Select one or more indices containing the {field} field. All users specified in the {field} field will be defined as privileged users.",
    values: {
      field: /*#__PURE__*/_react.default.createElement("code", null, 'user.name')
    }
  })), /*#__PURE__*/_react.default.createElement("h4", null, isFetching && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    "data-test-subj": "loading-indices-spinner"
  }), monitoredIndices.length === 0 && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.manageDataSources.indices.noIndicesAdded",
    defaultMessage: "No indices added"
  }), monitoredIndices.length > 0 && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.manageDataSources.indices.numIndicesAdded",
    defaultMessage: "{indexCount, plural, one {# index} other {# indices}} added",
    values: {
      indexCount: monitoredIndices.length
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fullWidth: false,
    iconType: "plusInCircle",
    onClick: showIndexModal
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.manageDataSources.indices.btnText",
    defaultMessage: "Select index"
  }))), isIndexModalOpen && /*#__PURE__*/_react.default.createElement(_select_index_modal.IndexSelectorModal, {
    onClose: hideIndexModal,
    onImport: onImport,
    editDataSource: monitoredDataSource
  }));
};
exports.IndexImportManageDataSource = IndexImportManageDataSource;