"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsLinkedToLists = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var i18n = _interopRequireWildcard(require("./translations"));
var _utils = require("../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SectionHeader = (0, _styledComponents.default)(_eui.EuiTitle)`
  ${() => (0, _styledComponents.css)`
    font-weight: ${({
  theme
}) => theme.eui.euiFontWeightSemiBold};
  `}
`;
const ExceptionsLinkedToListsComponent = ({
  isLoadingReferences,
  errorFetchingReferences,
  listAndReferences
}) => {
  const [message, setMessage] = (0, _react.useState)(/*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 4,
    "data-test-subj": "exceptionItemListsTableLoading"
  }));
  const [error, setError] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    if (errorFetchingReferences) {
      setError(i18n.LINKED_TO_LIST_ERROR);
    } else if (!isLoadingReferences) {
      setMessage(undefined);
    }
  }, [errorFetchingReferences, isLoadingReferences]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    hasShadow: false,
    "data-test-subj": "exceptionItemLinkedToListSection"
  }, /*#__PURE__*/_react.default.createElement(SectionHeader, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, i18n.LINKED_TO_LIST_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    tableCaption: "Table of exception lists",
    itemId: "id",
    message: message,
    loading: isLoadingReferences,
    items: listAndReferences,
    error: error,
    columns: (0, _utils.getSharedListsTableColumns)(),
    sorting: true,
    "data-test-subj": "exceptionItemSharedList"
  }));
};
const ExceptionsLinkedToLists = exports.ExceptionsLinkedToLists = /*#__PURE__*/_react.default.memo(ExceptionsLinkedToListsComponent);
ExceptionsLinkedToLists.displayName = 'ExceptionsLinkedToLists';