"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskEngineTaskStatusValuesEnum = exports.RiskEngineTaskStatusValues = exports.RiskEngineTaskStatus = exports.RiskEngineStatusResponse = exports.RiskEngineStatusEnum = exports.RiskEngineStatus = exports.GetRiskEngineStatusResponse = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Risk Scoring API
 *   version: 1
 */

const RiskEngineStatus = exports.RiskEngineStatus = _zod.z.enum(['NOT_INSTALLED', 'DISABLED', 'ENABLED']);
const RiskEngineStatusEnum = exports.RiskEngineStatusEnum = RiskEngineStatus.enum;
const RiskEngineTaskStatusValues = exports.RiskEngineTaskStatusValues = _zod.z.enum(['idle', 'claiming', 'running', 'failed', 'should_delete', 'unrecognized', 'dead_letter']);
const RiskEngineTaskStatusValuesEnum = exports.RiskEngineTaskStatusValuesEnum = RiskEngineTaskStatusValues.enum;
const RiskEngineTaskStatus = exports.RiskEngineTaskStatus = _zod.z.object({
  status: RiskEngineTaskStatusValues,
  runAt: _zod.z.string().datetime(),
  startedAt: _zod.z.string().datetime().optional()
});
const RiskEngineStatusResponse = exports.RiskEngineStatusResponse = _zod.z.object({
  risk_engine_status: RiskEngineStatus,
  risk_engine_task_status: RiskEngineTaskStatus.optional()
});
const GetRiskEngineStatusResponse = exports.GetRiskEngineStatusResponse = RiskEngineStatusResponse;