"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateApiKeyQuery = void 0;
var _reactQuery = require("@kbn/react-query");
var _reactHookForm = require("react-hook-form");
var _use_kibana = require("./use_kibana");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCreateApiKeyQuery = () => {
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const {
    getValues
  } = (0, _reactHookForm.useFormContext)();
  const {
    data,
    isError,
    isLoading,
    isSuccess,
    mutateAsync
  } = (0, _reactQuery.useMutation)({
    mutationFn: async ({
      name,
      expiresInDays
    }) => {
      const response = await services.http.post(_types.APIRoutes.POST_API_KEY, {
        body: JSON.stringify({
          name,
          expiresInDays,
          indices: getValues(_types.PlaygroundFormFields.indices)
        })
      });
      return response.apiKey.encoded;
    }
  });
  return {
    apiKey: data,
    isLoading,
    isSuccess,
    isError,
    action: mutateAsync
  };
};
exports.useCreateApiKeyQuery = useCreateApiKeyQuery;