"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackQueriesAttachmentWrapper = exports.CasesAttachmentWrapperContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _pack_queries_status_table = require("../../live_queries/form/pack_queries_status_table");
var _use_live_query_details = require("../../actions/use_live_query_details");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PackQueriesAttachmentWrapper = ({
  actionId,
  agentIds,
  queryId
}) => {
  const [isLive, setIsLive] = (0, _react.useState)(false);
  const {
    data
  } = (0, _use_live_query_details.useLiveQueryDetails)({
    actionId,
    isLive,
    ...(queryId ? {
      queryIds: [queryId]
    } : {})
  });
  (0, _react.useLayoutEffect)(() => {
    setIsLive(() => !((data === null || data === void 0 ? void 0 : data.status) === 'completed'));
  }, [data === null || data === void 0 ? void 0 : data.status]);
  return /*#__PURE__*/_react.default.createElement(CasesAttachmentWrapperContext.Provider, {
    value: true
  }, /*#__PURE__*/_react.default.createElement(_pack_queries_status_table.PackQueriesStatusTable, {
    actionId: actionId,
    queryId: queryId,
    data: data === null || data === void 0 ? void 0 : data.queries,
    startDate: data === null || data === void 0 ? void 0 : data['@timestamp'],
    expirationDate: data === null || data === void 0 ? void 0 : data.expiration,
    agentIds: agentIds
  }));
};
exports.PackQueriesAttachmentWrapper = PackQueriesAttachmentWrapper;
const CasesAttachmentWrapperContext = exports.CasesAttachmentWrapperContext = /*#__PURE__*/_react.default.createContext(false);