"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeedbackButtons = FeedbackButtons;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_kibana = require("../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const THANK_YOU_MESSAGE = _i18n.i18n.translate('xpack.observabilityAiAssistant.feedbackButtons.em.thanksForYourFeedbackLabel', {
  defaultMessage: 'Thanks for your feedback'
});
function FeedbackButtons({
  onClickFeedback
}) {
  const {
    notifications
  } = (0, _use_kibana.useKibana)().services;
  const [hasBeenClicked, setHasBeenClicked] = (0, _react.useState)(false);
  const handleClickPositive = () => {
    onClickFeedback('positive');
    setHasBeenClicked(true);
    notifications.toasts.addSuccess(THANK_YOU_MESSAGE);
  };
  const handleClickNegative = () => {
    onClickFeedback('negative');
    setHasBeenClicked(true);
    notifications.toasts.addSuccess(THANK_YOU_MESSAGE);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    direction: "row",
    alignItems: "center",
    gutterSize: "s",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("em", null, _i18n.i18n.translate('xpack.observabilityAiAssistant.insight.feedbackButtons.title', {
    defaultMessage: 'Was this helpful?'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    direction: "row",
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "observabilityAiAssistantFeedbackButtonsPositiveButton",
    color: "success",
    disabled: hasBeenClicked,
    iconType: "faceHappy",
    size: "s",
    onClick: handleClickPositive
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.insight.feedbackButtons.positive', {
    defaultMessage: 'Yes'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "observabilityAiAssistantFeedbackButtonsNegativeButton",
    color: "danger",
    disabled: hasBeenClicked,
    iconType: "faceSad",
    size: "s",
    onClick: handleClickNegative
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.insight.feedbackButtons.negative', {
    defaultMessage: 'No'
  }))))));
}