"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HEADER_ITEMS_LOADING = exports.ExpandableSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_exploration_url_state = require("../../hooks/use_exploration_url_state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isHeaderItems = arg => {
  return Array.isArray(arg);
};
const HEADER_ITEMS_LOADING = exports.HEADER_ITEMS_LOADING = 'header_items_loading';
const ExpandableSection = ({
  headerItems,
  content,
  isExpanded: isExpandedDefault,
  contentPadding = false,
  dataTestId,
  title,
  docsLink,
  urlStateKey
}) => {
  const {
    euiTheme: {
      size
    }
  } = (0, _eui.useEuiTheme)();
  const overrides = (0, _react.useMemo)(() => isExpandedDefault !== undefined ? {
    [urlStateKey]: isExpandedDefault
  } : undefined, [urlStateKey, isExpandedDefault]);
  const [pageUrlState, setPageUrlState] = (0, _use_exploration_url_state.useExplorationUrlState)(overrides);
  const isExpanded = isExpandedDefault !== undefined && pageUrlState[urlStateKey] === (0, _use_exploration_url_state.getDefaultExplorationPageUrlState)(overrides)[urlStateKey] ? isExpandedDefault : pageUrlState[urlStateKey];
  const toggleExpanded = (0, _react.useCallback)(() => {
    setPageUrlState({
      [urlStateKey]: !isExpanded
    });
  }, [isExpanded, setPageUrlState, urlStateKey]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    "data-test-subj": `mlDFExpandableSection-${dataTestId}`,
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: toggleExpanded,
    iconType: isExpanded ? 'arrowDown' : 'arrowRight',
    iconSide: "left",
    "data-test-subj": `mlDFExpandableSection-${dataTestId}-toggle-button`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    color: "default",
    style: {
      fontWeight: 'bold'
    }
  }, /*#__PURE__*/_react.default.createElement("p", null, title)))), headerItems === HEADER_ITEMS_LOADING && /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 1
  }), isHeaderItems(headerItems) ? headerItems.map(({
    label,
    value,
    id
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: id,
    "data-test-subj": `mlDFExpandableSectionItem-${dataTestId}-${id}`
  }, label !== undefined && value !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement("p", null, label))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, value))) : null, label === undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    textAlign: "center"
  }, value))) : null)) : null)), docsLink !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, docsLink)), isExpanded && /*#__PURE__*/_react.default.createElement("div", {
    css: contentPadding ? {
      padding: `${size.s}`
    } : undefined,
    "data-test-subj": `mlDFExpandableSection-${dataTestId}-content`
  }, content));
};
exports.ExpandableSection = ExpandableSection;