"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FLYOUT_STATE = exports.DEFAULT_MAP_UI_STATE = exports.DEFAULT_IS_LAYER_TOC_OPEN = void 0;
exports.ui = ui;
var _kibana_services = require("../kibana_services");
var _actions = require("../actions");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable @typescript-eslint/consistent-type-definitions */
let FLYOUT_STATE = exports.FLYOUT_STATE = /*#__PURE__*/function (FLYOUT_STATE) {
  FLYOUT_STATE["NONE"] = "NONE";
  FLYOUT_STATE["LAYER_PANEL"] = "LAYER_PANEL";
  FLYOUT_STATE["ADD_LAYER_WIZARD"] = "ADD_LAYER_WIZARD";
  FLYOUT_STATE["MAP_SETTINGS_PANEL"] = "MAP_SETTINGS_PANEL";
  return FLYOUT_STATE;
}({});
const DEFAULT_IS_LAYER_TOC_OPEN = exports.DEFAULT_IS_LAYER_TOC_OPEN = true;
const DEFAULT_MAP_UI_STATE = exports.DEFAULT_MAP_UI_STATE = {
  flyoutDisplay: FLYOUT_STATE.NONE,
  drawMode: _constants.DRAW_MODE.NONE,
  isFullScreen: false,
  isReadOnly: !(0, _kibana_services.getMapsCapabilities)().save,
  isLayerTOCOpen: DEFAULT_IS_LAYER_TOC_OPEN,
  isTimesliderOpen: false,
  // storing TOC detail visibility outside of map.layerList because its UI state and not map rendering state.
  // This also makes for easy read/write access for embeddables.
  openTOCDetails: [],
  autoOpenLayerWizardId: '',
  deletedFeatureIds: []
};

// Reducer
function ui(state = DEFAULT_MAP_UI_STATE, action) {
  switch (action.type) {
    case _actions.UPDATE_FLYOUT:
      return {
        ...state,
        flyoutDisplay: action.display
      };
    case _actions.SET_DRAW_MODE:
      return {
        ...state,
        drawMode: action.drawMode
      };
    case _actions.SET_IS_LAYER_TOC_OPEN:
      return {
        ...state,
        isLayerTOCOpen: action.isLayerTOCOpen
      };
    case _actions.SET_IS_TIME_SLIDER_OPEN:
      return {
        ...state,
        isTimesliderOpen: action.isTimesliderOpen
      };
    case _actions.SET_FULL_SCREEN:
      return {
        ...state,
        isFullScreen: action.isFullScreen
      };
    case _actions.SET_READ_ONLY:
      return {
        ...state,
        isReadOnly: action.isReadOnly
      };
    case _actions.SET_OPEN_TOC_DETAILS:
      return {
        ...state,
        openTOCDetails: action.layerIds
      };
    case _actions.SHOW_TOC_DETAILS:
      return {
        ...state,
        openTOCDetails: [...state.openTOCDetails, action.layerId]
      };
    case _actions.HIDE_TOC_DETAILS:
      return {
        ...state,
        openTOCDetails: state.openTOCDetails.filter(layerId => {
          return layerId !== action.layerId;
        })
      };
    case _actions.SET_AUTO_OPEN_WIZARD_ID:
      return {
        ...state,
        autoOpenLayerWizardId: action.autoOpenLayerWizardId
      };
    case _actions.PUSH_DELETED_FEATURE_ID:
      return {
        ...state,
        deletedFeatureIds: [...state.deletedFeatureIds, action.featureId]
      };
    case _actions.CLEAR_DELETED_FEATURE_IDS:
      return {
        ...state,
        deletedFeatureIds: []
      };
    default:
      return state;
  }
}