"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLayersExtent = getLayersExtent;
var _bbox = _interopRequireDefault(require("@turf/bbox"));
var _helpers = require("@turf/helpers");
var _elasticsearch_util = require("../../common/elasticsearch_util");
var _data_request = require("../classes/util/data_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getLayersExtent(layers, getDataRequestContext) {
  if (!layers.length) {
    return null;
  }
  const boundsPromises = layers.map(async layer => {
    if (!(await layer.isFittable())) {
      return null;
    }
    return layer.getBounds(getDataRequestContext);
  });
  let bounds;
  try {
    bounds = await Promise.all(boundsPromises);
  } catch (error) {
    if (!(error instanceof _data_request.DataRequestAbortError)) {
      // eslint-disable-next-line no-console
      console.warn('Unhandled getBounds error for layer. Only DataRequestAbortError should be surfaced', error);
    }
    // new fitToDataBounds request has superseded this thread of execution. Results no longer needed.
    return null;
  }
  const corners = [];
  for (let i = 0; i < bounds.length; i++) {
    const b = bounds[i];

    // filter out undefined bounds (uses Infinity due to turf responses)
    if (b === null || b.minLon === Infinity || b.maxLon === Infinity || b.minLat === -Infinity || b.maxLat === -Infinity) {
      continue;
    }
    corners.push([b.minLon, b.minLat]);
    corners.push([b.maxLon, b.maxLat]);
  }
  return corners.length ? (0, _elasticsearch_util.turfBboxToBounds)((0, _bbox.default)((0, _helpers.multiPoint)(corners))) : null;
}