"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LogColumnHeadersWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
var _react2 = _interopRequireDefault(require("react"));
var _vertical_scroll_panel = require("./vertical_scroll_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogColumnHeadersWrapper = ({
  role = 'row',
  ...props
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement("div", (0, _extends2.default)({
    role: role,
    css: (0, _react.css)`
        align-items: stretch;
        display: flex;
        flex-direction: row;
        flex-wrap: nowrap;
        justify-content: flex-start;
        overflow: hidden;
        padding-right: ${_vertical_scroll_panel.ASSUMED_SCROLLBAR_WIDTH}px;
        border-bottom: ${euiTheme.border.thin};
        box-shadow: 0 2px 2px -1px ${euiTheme.colors.borderBaseSubdued};
        position: relative;
        z-index: 1;
      `
  }, props));
};

// eslint-disable-next-line import/no-default-export
exports.LogColumnHeadersWrapper = LogColumnHeadersWrapper;
var _default = exports.default = LogColumnHeadersWrapper;