"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceDefinition = exports.linksUpdateOptionsSchema = exports.linksSearchOptionsSchema = exports.linksGetResultSchema = exports.linksCreateResultSchema = exports.linksCreateOptionsSchema = exports.linksAttributesSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _contentManagementUtils = require("@kbn/content-management-utils");
var _v = require("../../../../common/content_management/v1");
var _constants = require("../../../../common/content_management/v1/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const baseLinkSchema = {
  id: _configSchema.schema.string({
    meta: {
      description: 'The unique ID of the link'
    }
  }),
  label: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'The label of the link to be displayed in the UI'
    }
  })),
  order: _configSchema.schema.number({
    meta: {
      description: 'The position this link should appear in the order of the list'
    }
  })
};
const dashboardLinkSchema = _configSchema.schema.object({
  ...baseLinkSchema,
  destinationRefName: _configSchema.schema.string({
    meta: {
      description: 'The name of the SavedObject reference to the linked dashboard'
    }
  }),
  type: _configSchema.schema.literal(_v.DASHBOARD_LINK_TYPE),
  options: _configSchema.schema.maybe(_configSchema.schema.object({
    openInNewTab: _configSchema.schema.boolean({
      meta: {
        description: 'Whether to open this link in a new tab when clicked'
      }
    }),
    useCurrentFilters: _configSchema.schema.boolean({
      meta: {
        description: 'Whether to use the filters and query from the origin dashboard'
      }
    }),
    useCurrentDateRange: _configSchema.schema.boolean({
      meta: {
        description: 'Whether to use the date range from the origin dashboard'
      }
    })
  }, {
    unknowns: 'forbid'
  }))
});
const externalLinkSchema = _configSchema.schema.object({
  ...baseLinkSchema,
  type: _configSchema.schema.literal(_v.EXTERNAL_LINK_TYPE),
  destination: _configSchema.schema.string({
    meta: {
      description: 'The external URL to link to'
    }
  }),
  options: _configSchema.schema.maybe(_configSchema.schema.object({
    openInNewTab: _configSchema.schema.boolean({
      meta: {
        description: 'Whether to open this link in a new tab when clicked'
      }
    }),
    encodeUrl: _configSchema.schema.boolean({
      meta: {
        description: 'Whether to escape the URL with percent encoding'
      }
    })
  }, {
    unknowns: 'forbid'
  }))
});
const linksAttributesSchema = exports.linksAttributesSchema = _configSchema.schema.object({
  title: _configSchema.schema.string({
    meta: {
      description: 'A human-readable title for the dashboard'
    }
  }),
  description: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'A short description.'
    }
  })),
  links: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([dashboardLinkSchema, externalLinkSchema]), {
    meta: {
      description: 'The list of links to display'
    }
  }),
  layout: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.LINKS_HORIZONTAL_LAYOUT), _configSchema.schema.literal(_constants.LINKS_VERTICAL_LAYOUT)], {
    meta: {
      description: 'Denote whether to display the links in a horizontal or vertical layout'
    }
  }))
}, {
  unknowns: 'forbid'
});
const linksSavedObjectSchema = (0, _contentManagementUtils.savedObjectSchema)(linksAttributesSchema);
const linksSearchOptionsSchema = exports.linksSearchOptionsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  onlyTitle: _configSchema.schema.maybe(_configSchema.schema.boolean())
}, {
  unknowns: 'forbid'
}));
const linksCreateOptionsSchema = exports.linksCreateOptionsSchema = _configSchema.schema.object({
  references: _configSchema.schema.maybe(_contentManagementUtils.createOptionsSchemas.references),
  overwrite: _contentManagementUtils.createOptionsSchemas.overwrite
});
const linksUpdateOptionsSchema = exports.linksUpdateOptionsSchema = _configSchema.schema.object({
  references: _contentManagementUtils.updateOptionsSchema.references
});
const linksGetResultSchema = exports.linksGetResultSchema = (0, _contentManagementUtils.objectTypeToGetResultSchema)(linksSavedObjectSchema);
const linksCreateResultSchema = exports.linksCreateResultSchema = (0, _contentManagementUtils.createResultSchema)(linksSavedObjectSchema);

// Content management service definition.
// We need it for BWC support between different versions of the content
const serviceDefinition = exports.serviceDefinition = {
  get: {
    out: {
      result: {
        schema: linksGetResultSchema
      }
    }
  },
  create: {
    in: {
      options: {
        schema: linksCreateOptionsSchema
      },
      data: {
        schema: linksAttributesSchema
      }
    },
    out: {
      result: {
        schema: linksCreateResultSchema
      }
    }
  },
  update: {
    in: {
      options: {
        schema: linksUpdateOptionsSchema // same schema as "create"
      },
      data: {
        schema: linksAttributesSchema
      }
    }
  },
  search: {
    in: {
      options: {
        schema: linksSearchOptionsSchema
      }
    }
  },
  mSearch: {
    out: {
      result: {
        schema: linksSavedObjectSchema
      }
    }
  }
};