"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DropdownButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _kubernetes_tour = require("./kubernetes_tour");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ButtonLabel = ({
  label,
  theme
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  css: {
    padding: 12,
    background: theme === null || theme === void 0 ? void 0 : theme.colors.backgroundBaseFormsPrepend,
    fontSize: '0.75em',
    fontWeight: 600,
    color: theme === null || theme === void 0 ? void 0 : theme.colors.textHeading,
    borderRight: theme === null || theme === void 0 ? void 0 : theme.border.thin
  }
}, label);
const DropdownButton = exports.DropdownButton = (0, _eui.withEuiTheme)(props => {
  const {
    onClick,
    label,
    theme,
    children,
    showKubernetesInfo
  } = props;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    css: {
      border: theme === null || theme === void 0 ? void 0 : theme.euiTheme.border.thin
    }
  }, showKubernetesInfo ? /*#__PURE__*/_react.default.createElement(_kubernetes_tour.KubernetesTour, null, /*#__PURE__*/_react.default.createElement(ButtonLabel, {
    label: label,
    theme: theme.euiTheme
  })) : /*#__PURE__*/_react.default.createElement(ButtonLabel, {
    label: label,
    theme: theme.euiTheme
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.infra.dropdownButton.button.ariaLabel', {
      defaultMessage: '{label} options',
      values: {
        label
      }
    }),
    "data-test-subj": props['data-test-subj'],
    color: "text",
    iconType: "arrowDown",
    onClick: onClick,
    iconSide: "right",
    size: "xs",
    css: (0, _react2.css)`
            &::before {
              background: none !important;
            }
          `
  }, children)));
});