"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapWithSimulatedFunctionCalling = wrapWithSimulatedFunctionCalling;
var _inferenceCommon = require("@kbn/inference-common");
var _constants = require("./constants");
var _get_system_instructions = require("./get_system_instructions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function replaceFunctionsWithTools(content) {
  return content.replaceAll(/(function)(s|[\s*\.])?(?!\scall)/g, (match, p1, p2) => {
    return `tool${p2 || ''}`;
  });
}
function wrapWithSimulatedFunctionCalling({
  messages,
  system,
  tools,
  toolChoice
}) {
  const instructions = (0, _get_system_instructions.getSystemMessageInstructions)({
    tools
  });
  const wrappedSystem = system ? `${system}\n${instructions}` : instructions;
  const wrappedMessages = messages.map(message => {
    var _message$toolCalls;
    if (message.role === _inferenceCommon.MessageRole.Tool) {
      return convertToolResponseMessage(message);
    }
    if (message.role === _inferenceCommon.MessageRole.Assistant && (_message$toolCalls = message.toolCalls) !== null && _message$toolCalls !== void 0 && _message$toolCalls.length) {
      return convertToolCallMessage(message);
    }
    return message;
  }).map(message => {
    let content = message.content;
    if (typeof content === 'string') {
      content = replaceFunctionsWithTools(content);
    } else if (Array.isArray(content)) {
      content = content.map(contentPart => {
        if (contentPart.type === 'text') {
          return {
            ...contentPart,
            text: replaceFunctionsWithTools(contentPart.text)
          };
        }
        return contentPart;
      });
    }
    return {
      ...message,
      content
    };
  });
  if (toolChoice) {
    let selectionMessage;
    if (typeof toolChoice === 'object') {
      selectionMessage = `Remember, use the ${toolChoice.function} tool to answer this question.`;
    } else if (toolChoice === _inferenceCommon.ToolChoiceType.required) {
      selectionMessage = `Remember, you MUST use one of the provided tool to answer this question.`;
    } else if (toolChoice === _inferenceCommon.ToolChoiceType.auto) {
      selectionMessage = `Remember, you CAN use one of the provided tool to answer this question.`;
    }
    if (selectionMessage) {
      wrappedMessages[messages.length - 1].content += `\n${selectionMessage}`;
    }
  }
  return {
    messages: wrappedMessages,
    system: wrappedSystem
  };
}
const convertToolResponseMessage = message => {
  return {
    role: _inferenceCommon.MessageRole.User,
    content: JSON.stringify({
      type: 'tool_result',
      tool: message.toolCallId,
      response: message.response
    })
  };
};
const convertToolCallMessage = message => {
  // multi-call not supported by simulated mode, there will never be more than one
  const toolCall = message.toolCalls[0];
  let content = message.content || '';
  content += _constants.TOOL_USE_START + '\n```json\n' + JSON.stringify({
    name: toolCall.function.name,
    input: 'arguments' in toolCall.function ? toolCall.function.arguments : {}
  }) + '\n```' + _constants.TOOL_USE_END;
  return {
    role: _inferenceCommon.MessageRole.Assistant,
    content
  };
};