"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inferenceEndpointExists = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const inferenceEndpointExists = async (esClient, inferenceEndpointId) => {
  try {
    await esClient.inference.get({
      inference_id: inferenceEndpointId
    });
    return true;
  } catch (err) {
    if ((err === null || err === void 0 ? void 0 : err.statusCode) === 404) {
      return false;
    } else {
      throw err;
    }
  }
};
exports.inferenceEndpointExists = inferenceEndpointExists;