"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DrillDownIconLinks = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _icon_renderer = require("../icon_renderer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DrillDownIconLinks = ({
  hasNodes,
  urlTemplates,
  openUrlTemplate
}) => {
  const drillDownsWithIcons = urlTemplates.filter(({
    icon
  }) => icon && icon.id !== '');
  if (drillDownsWithIcons.length === 0) {
    return null;
  }
  const drillDowns = drillDownsWithIcons.map(cur => {
    const onUrlTemplateClick = () => openUrlTemplate(cur);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: cur.description
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: cur.icon ? () => /*#__PURE__*/_react.default.createElement(_icon_renderer.IconRenderer, {
        icon: cur.icon
      }) : '',
      size: "xs",
      isDisabled: hasNodes,
      onClick: onUrlTemplateClick
    })));
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center",
    gutterSize: "xs",
    responsive: false,
    css: ({
      euiTheme
    }) => (0, _react2.css)({
      marginTop: `calc(0.5 * ${euiTheme.size.xs})`,
      marginBottom: `calc(0.5 * ${euiTheme.size.xs})`
    })
  }, drillDowns);
};
exports.DrillDownIconLinks = DrillDownIconLinks;