"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradePackagePoliciesResponseBodySchema = exports.UpgradePackagePoliciesRequestSchema = exports.UpdatePackagePolicyRequestSchema = exports.GetPackagePoliciesRequestSchema = exports.GetOnePackagePolicyRequestSchema = exports.DryRunPackagePoliciesResponseBodySchema = exports.DryRunPackagePoliciesRequestSchema = exports.DeletePackagePoliciesResponseBodySchema = exports.DeletePackagePoliciesRequestSchema = exports.DeleteOnePackagePolicyResponseSchema = exports.DeleteOnePackagePolicyRequestSchema = exports.CreatePackagePolicyResponseSchema = exports.CreatePackagePolicyRequestSchema = exports.BulkGetPackagePoliciesResponseBodySchema = exports.BulkGetPackagePoliciesRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _models = require("../models");
var _constants = require("../../../common/constants");
var _constants2 = require("../../constants");
var _filter_utils = require("../../routes/utils/filter_utils");
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetPackagePoliciesRequestSchema = exports.GetPackagePoliciesRequestSchema = {
  query: _configSchema.schema.object({
    page: _configSchema.schema.maybe(_configSchema.schema.number({
      defaultValue: 1
    })),
    perPage: _configSchema.schema.maybe(_configSchema.schema.number({
      defaultValue: 20
    })),
    sortField: _configSchema.schema.maybe(_configSchema.schema.string()),
    sortOrder: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('desc'), _configSchema.schema.literal('asc')])),
    showUpgradeable: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    kuery: _configSchema.schema.maybe(_configSchema.schema.string({
      validate: value => {
        const validationObj = (0, _filter_utils.validateKuery)(value, [_constants2.LEGACY_PACKAGE_POLICY_SAVED_OBJECT_TYPE, _constants2.PACKAGE_POLICY_SAVED_OBJECT_TYPE], _constants2.PACKAGE_POLICIES_MAPPINGS, true);
        if (validationObj !== null && validationObj !== void 0 && validationObj.error) {
          return validationObj === null || validationObj === void 0 ? void 0 : validationObj.error;
        }
      }
    })),
    format: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.inputsFormat.Simplified), _configSchema.schema.literal(_constants.inputsFormat.Legacy)])),
    withAgentCount: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
const BulkGetPackagePoliciesRequestSchema = exports.BulkGetPackagePoliciesRequestSchema = {
  body: _common.BulkRequestBodySchema,
  query: _configSchema.schema.object({
    format: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.inputsFormat.Simplified), _configSchema.schema.literal(_constants.inputsFormat.Legacy)]))
  })
};
const BulkGetPackagePoliciesResponseBodySchema = exports.BulkGetPackagePoliciesResponseBodySchema = _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(_models.PackagePolicyResponseSchema)
});
const GetOnePackagePolicyRequestSchema = exports.GetOnePackagePolicyRequestSchema = {
  params: _configSchema.schema.object({
    packagePolicyId: _configSchema.schema.string()
  }),
  query: _configSchema.schema.object({
    format: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.inputsFormat.Simplified), _configSchema.schema.literal(_constants.inputsFormat.Legacy)]))
  })
};
const CreatePackagePolicyRequestSchema = exports.CreatePackagePolicyRequestSchema = {
  body: _configSchema.schema.oneOf([_models.CreatePackagePolicyRequestBodySchema, _models.SimplifiedCreatePackagePolicyRequestBodySchema], {
    meta: {
      description: 'You should use inputs as an object and not use the deprecated inputs array.'
    }
  }),
  query: _configSchema.schema.object({
    format: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.inputsFormat.Simplified), _configSchema.schema.literal(_constants.inputsFormat.Legacy)]))
  })
};
const CreatePackagePolicyResponseSchema = exports.CreatePackagePolicyResponseSchema = _configSchema.schema.object({
  item: _models.PackagePolicyResponseSchema
});
const UpdatePackagePolicyRequestSchema = exports.UpdatePackagePolicyRequestSchema = {
  ...GetOnePackagePolicyRequestSchema,
  body: _configSchema.schema.oneOf([_models.UpdatePackagePolicyRequestBodySchema, _models.SimplifiedCreatePackagePolicyRequestBodySchema]),
  query: _configSchema.schema.object({
    format: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.inputsFormat.Simplified), _configSchema.schema.literal(_constants.inputsFormat.Legacy)]))
  })
};
const DeletePackagePoliciesRequestSchema = exports.DeletePackagePoliciesRequestSchema = {
  body: _configSchema.schema.object({
    packagePolicyIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
    force: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
const DeletePackagePoliciesResponseBodySchema = exports.DeletePackagePoliciesResponseBodySchema = _configSchema.schema.arrayOf(_models.PackagePolicyStatusResponseSchema.extends({
  policy_id: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.string({
    meta: {
      description: 'Use `policy_ids` instead',
      deprecated: true
    }
  })])),
  policy_ids: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  output_id: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.string()])),
  package: _models.PackagePolicyPackageSchema
}));
const DeleteOnePackagePolicyRequestSchema = exports.DeleteOnePackagePolicyRequestSchema = {
  params: _configSchema.schema.object({
    packagePolicyId: _configSchema.schema.string()
  }),
  query: _configSchema.schema.object({
    force: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
const DeleteOnePackagePolicyResponseSchema = exports.DeleteOnePackagePolicyResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string()
});
const UpgradePackagePoliciesRequestSchema = exports.UpgradePackagePoliciesRequestSchema = {
  body: _configSchema.schema.object({
    packagePolicyIds: _configSchema.schema.arrayOf(_configSchema.schema.string())
  })
};
const UpgradePackagePoliciesResponseBodySchema = exports.UpgradePackagePoliciesResponseBodySchema = _configSchema.schema.arrayOf(_models.PackagePolicyStatusResponseSchema);
const DryRunPackagePoliciesRequestSchema = exports.DryRunPackagePoliciesRequestSchema = {
  body: _configSchema.schema.object({
    packagePolicyIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
    packageVersion: _configSchema.schema.maybe(_configSchema.schema.string())
  })
};
const DryRunPackagePoliciesResponseBodySchema = exports.DryRunPackagePoliciesResponseBodySchema = _configSchema.schema.arrayOf(_configSchema.schema.object({
  name: _configSchema.schema.maybe(_configSchema.schema.string()),
  statusCode: _configSchema.schema.maybe(_configSchema.schema.number()),
  body: _configSchema.schema.maybe(_configSchema.schema.object({
    message: _configSchema.schema.string()
  })),
  hasErrors: _configSchema.schema.boolean(),
  diff: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_models.PackagePolicyResponseSchema.extends({
    id: _configSchema.schema.maybe(_configSchema.schema.string())
  }), _models.DryRunPackagePolicySchema]))),
  agent_diff: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.string(),
    name: _configSchema.schema.string(),
    revision: _configSchema.schema.number(),
    type: _configSchema.schema.string(),
    data_stream: _configSchema.schema.object({
      namespace: _configSchema.schema.string()
    }),
    use_output: _configSchema.schema.string(),
    package_policy_id: _configSchema.schema.string(),
    meta: _configSchema.schema.maybe(_configSchema.schema.object({
      package: _configSchema.schema.object({
        name: _configSchema.schema.string(),
        version: _configSchema.schema.string()
      }).extendsDeep({
        // equivalent of allowing extra keys like `[key: string]: any;`
        unknowns: 'allow'
      })
    })),
    streams: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
      id: _configSchema.schema.maybe(_configSchema.schema.string()),
      data_stream: _configSchema.schema.object({
        dataset: _configSchema.schema.string(),
        type: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }).extendsDeep({
      unknowns: 'allow'
    }))),
    processors: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
      add_fields: _configSchema.schema.object({
        target: _configSchema.schema.string(),
        fields: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number()]))
      })
    })))
  }).extendsDeep({
    unknowns: 'allow'
  }))))
}));