"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GridColumn = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _reactWindow = require("react-window");
var _i18nReact = require("@kbn/i18n-react");
var _reactVirtualized = require("react-virtualized");
var _package_card = require("../package_card");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VirtualizedRow = ({
  index,
  children,
  style,
  onHeightChange
}) => {
  const ref = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (ref.current) {
      onHeightChange(index, ref.current.clientHeight);
    }
  }, [index, onHeightChange]);
  return /*#__PURE__*/_react.default.createElement("div", {
    style: style
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: ref
  }, children, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })));
};
const CARD_OFFSET = 16;
const GridColumn = ({
  list,
  showMissingIntegrationMessage = false,
  showCardLabels = false,
  isLoading,
  scrollElementId,
  emptyStateStyles
}) => {
  var _document$getElementB;
  const itemsSizeRefs = (0, _react.useRef)(new Map());
  const listRef = (0, _react.useRef)(null);
  const onHeightChange = (0, _react.useCallback)((index, size) => {
    itemsSizeRefs.current.set(index, size);
    if (listRef.current) {
      listRef.current.resetAfterIndex(index);
    }
  }, []);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
      gutterSize: "l",
      columns: 3
    }, Array.from({
      length: 12
    }).map((_, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: index,
      grow: 3
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      height: "160px",
      width: "100%"
    }))));
  }
  if (!list.length) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
      gutterSize: "l",
      columns: 3,
      "data-test-subj": "emptyState",
      style: emptyStateStyles
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 3
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, showMissingIntegrationMessage ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmList.missingIntegrationPlaceholder",
      defaultMessage: "We didn't find any integrations matching your search term. Please try another keyword or browse using the categories on the left."
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmList.noPackagesFoundPlaceholder",
      defaultMessage: "No integrations found"
    })))));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactVirtualized.WindowScroller, {
    onScroll: ({
      scrollTop
    }) => {
      if (listRef.current) {
        listRef.current.scrollTo(scrollTop);
      }
    },
    scrollElement: scrollElementId ? (_document$getElementB = document.getElementById(scrollElementId)) !== null && _document$getElementB !== void 0 ? _document$getElementB : undefined : undefined
  }, () => /*#__PURE__*/_react.default.createElement(_eui.EuiAutoSizer, {
    disableHeight: true
  }, ({
    width
  }) => /*#__PURE__*/_react.default.createElement(_reactWindow.VariableSizeList, {
    style: {
      height: '100%',
      overflow: 'visible'
    },
    ref: listRef,
    layout: "vertical",
    itemCount: Math.ceil(list.length / 3),
    innerElementType: /*#__PURE__*/(0, _react.forwardRef)(({
      style,
      children,
      ...rest
    }, ref) => /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
      ref: ref
      // provides extra padding to the top and bottom of the list to prevent clipping and other strange behavior.
      // for more info see: https://github.com/bvaughn/react-window?tab=readme-ov-file#can-i-add-padding-to-the-top-and-bottom-of-a-list
      ,
      style: {
        ...style,
        height: `${parseFloat(style.height) + CARD_OFFSET * 2}px`
      }
    }, rest), children)),
    itemSize: index => {
      var _itemsSizeRefs$curren;
      const test = (_itemsSizeRefs$curren = itemsSizeRefs.current.get(index)) !== null && _itemsSizeRefs$curren !== void 0 ? _itemsSizeRefs$curren : 200;
      return test;
    },
    height: window.innerHeight // plus Don't see an integration message
    ,
    estimatedItemSize: 200,
    width: width
  }, ({
    index,
    style
  }) => {
    var _Number;
    return /*#__PURE__*/_react.default.createElement(VirtualizedRow, {
      index: index
      // this is necessary to prevent clipping of the first row during animaiton, or if the cards have a badge.
      // for more info see: https://github.com/bvaughn/react-window?tab=readme-ov-file#can-i-add-padding-to-the-top-and-bottom-of-a-list
      ,
      style: {
        ...style,
        top: `${((_Number = Number(style.top)) !== null && _Number !== void 0 ? _Number : 0) + CARD_OFFSET}px`
      },
      onHeightChange: onHeightChange
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
      gutterSize: "l",
      columns: 3
    }, list.slice(index * 3, index * 3 + 3).map(item => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: item.id
        // Ensure that cards wrapped in EuiTours/EuiPopovers correctly inherit the full grid row height
        ,
        css: (0, _react2.css)`
                                min-width: 0;
                                & > .euiPopover,
                                & > .euiPopover > .euiCard {
                                  height: 100%;
                                }
                              `
      }, /*#__PURE__*/_react.default.createElement(_package_card.PackageCard, (0, _extends2.default)({}, item, {
        showLabels: showCardLabels
      })));
    })));
  }))));
};
exports.GridColumn = GridColumn;