"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationSyncFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
var _integration_status = require("./integration_status");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IntegrationSyncFlyout = exports.IntegrationSyncFlyout = /*#__PURE__*/(0, _react.memo)(({
  onClose,
  syncedIntegrationsStatus,
  outputName,
  syncUninstalledIntegrations
}) => {
  var _syncedIntegrationsSt;
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "aria-labelledby": flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrationSyncFlyout.titleText",
    defaultMessage: "Integration syncing status"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    "data-test-subj": "integrationSyncFlyoutHeaderText"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrationSyncFlyout.headerText",
    defaultMessage: "You're viewing sync activity for {outputName}. Check overall progress and view individual sync statuses from custom assets. {documentationLink}.",
    values: {
      outputName,
      documentationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: `${docLinks.links.fleet.remoteESOoutput}#automatic-integrations-synchronization`,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.integrationSyncFlyout.documentationLink",
        defaultMessage: "Learn more"
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, (syncedIntegrationsStatus === null || syncedIntegrationsStatus === void 0 ? void 0 : syncedIntegrationsStatus.error) && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrationSyncFlyout.errorTitle",
      defaultMessage: "Error"
    }),
    color: "danger",
    iconType: "error",
    size: "s",
    "data-test-subj": "integrationSyncFlyoutTopErrorCallout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, syncedIntegrationsStatus === null || syncedIntegrationsStatus === void 0 ? void 0 : syncedIntegrationsStatus.error)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, ((_syncedIntegrationsSt = syncedIntegrationsStatus === null || syncedIntegrationsStatus === void 0 ? void 0 : syncedIntegrationsStatus.integrations) !== null && _syncedIntegrationsSt !== void 0 ? _syncedIntegrationsSt : [] // don't show integrations that were successfully uninstalled
  ).filter(integration => {
    var _integration$install_, _integration$install_2;
    return !(((_integration$install_ = integration.install_status) === null || _integration$install_ === void 0 ? void 0 : _integration$install_.main) === 'not_installed' && ((_integration$install_2 = integration.install_status) === null || _integration$install_2 === void 0 ? void 0 : _integration$install_2.remote) === 'not_installed');
  }).map(integration => {
    var _syncedIntegrationsSt2;
    const customAssets = Object.values((_syncedIntegrationsSt2 = syncedIntegrationsStatus === null || syncedIntegrationsStatus === void 0 ? void 0 : syncedIntegrationsStatus.custom_assets) !== null && _syncedIntegrationsSt2 !== void 0 ? _syncedIntegrationsSt2 : {}).filter(asset => asset.package_name === integration.package_name);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: integration.package_name
    }, /*#__PURE__*/_react.default.createElement(_integration_status.IntegrationStatus, {
      "data-test-subj": `${integration.package_name}-accordion`,
      integration: integration,
      customAssets: customAssets,
      syncUninstalledIntegrations: syncUninstalledIntegrations
    }));
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrationSyncFlyout.closeFlyoutButtonLabel",
    defaultMessage: "Close"
  }))))));
});