"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.operatorFunctionDefinitions = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("../types");
var _esql_types = require("../../shared/esql_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * __AUTOGENERATED FILE. DO NOT EDIT THIS FILE DIRECTLY.__
 *
 * @note This file is generated by the `generate_function_definitions.ts`
 * script. Do not edit it manually.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const addDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: '+',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.add', {
    defaultMessage: 'Add two numbers together. If either field is multivalued then the result is `null`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'date',
      optional: false
    }, {
      name: 'right',
      type: 'date_period',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false
    }, {
      name: 'right',
      type: 'time_duration',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'right',
      type: 'date_period',
      optional: false
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'right',
      type: 'time_duration',
      optional: false
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'left',
      type: 'date_period',
      optional: false
    }, {
      name: 'right',
      type: 'date',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'left',
      type: 'date_period',
      optional: false
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'left',
      type: 'date_period',
      optional: false
    }, {
      name: 'right',
      type: 'date_period',
      optional: false
    }],
    returnType: 'date_period'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'time_duration',
      optional: false
    }, {
      name: 'right',
      type: 'date',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'left',
      type: 'time_duration',
      optional: false
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'left',
      type: 'time_duration',
      optional: false
    }, {
      name: 'right',
      type: 'time_duration',
      optional: false
    }],
    returnType: 'time_duration'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'right',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }, {
    params: [{
      name: 'left',
      type: 'time_duration'
    }, {
      name: 'right',
      type: 'date'
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'left',
      type: 'date'
    }, {
      name: 'right',
      type: 'time_duration'
    }],
    returnType: 'date'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_WHERE, _types.Location.STATS_BY, _types.Location.COMPLETION],
  validate: undefined,
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const divDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: '/',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.div', {
    defaultMessage: 'Divide one number by another. If either field is multivalued then the result is `null`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'right',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_WHERE, _types.Location.STATS_BY, _types.Location.COMPLETION],
  validate: fnDef => {
    const [left, right] = fnDef.args;
    const messages = [];
    if (!Array.isArray(left) && !Array.isArray(right)) {
      if (right.type === 'literal' && (0, _esql_types.isNumericType)(right.literalType)) {
        if (right.value === 0) {
          messages.push({
            type: 'warning',
            code: 'divideByZero',
            text: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.divide.warning.divideByZero', {
              defaultMessage: 'Cannot divide by zero: {left}/{right}',
              values: {
                left: left.text,
                right: right.value
              }
            }),
            location: fnDef.location
          });
        }
      }
    }
    return messages;
  },
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const equalsDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: '==',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.equals', {
    defaultMessage: 'Check if two fields are equal. If either field is multivalued then the result is `null`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'boolean',
      optional: false
    }, {
      name: 'right',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_point',
      optional: false
    }, {
      name: 'right',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_shape',
      optional: false
    }, {
      name: 'right',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false
    }, {
      name: 'right',
      type: 'date',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'right',
      type: 'date',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geo_point',
      optional: false
    }, {
      name: 'right',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geo_shape',
      optional: false
    }, {
      name: 'right',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false
    }, {
      name: 'right',
      type: 'ip',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false
    }, {
      name: 'right',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false
    }, {
      name: 'right',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false
    }, {
      name: 'right',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false
    }, {
      name: 'right',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'right',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false
    }, {
      name: 'right',
      type: 'version',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'ip'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'version'
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_WHERE, _types.Location.STATS_BY, _types.Location.COMPLETION],
  validate: undefined,
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const greaterThanDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: '>',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.greater_than', {
    defaultMessage: 'Check if one field is greater than another. If either field is multivalued then the result is `null`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'date',
      optional: false
    }, {
      name: 'right',
      type: 'date',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'right',
      type: 'date',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false
    }, {
      name: 'right',
      type: 'ip',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false
    }, {
      name: 'right',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false
    }, {
      name: 'right',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false
    }, {
      name: 'right',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false
    }, {
      name: 'right',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'right',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false
    }, {
      name: 'right',
      type: 'version',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'ip'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'version'
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_WHERE, _types.Location.STATS_BY, _types.Location.COMPLETION],
  validate: undefined,
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const greaterThanOrEqualDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: '>=',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.greater_than_or_equal', {
    defaultMessage: 'Check if one field is greater than or equal to another. If either field is multivalued then the result is `null`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'date',
      optional: false
    }, {
      name: 'right',
      type: 'date',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'right',
      type: 'date',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false
    }, {
      name: 'right',
      type: 'ip',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false
    }, {
      name: 'right',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false
    }, {
      name: 'right',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false
    }, {
      name: 'right',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false
    }, {
      name: 'right',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'right',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false
    }, {
      name: 'right',
      type: 'version',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'ip'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'version'
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_WHERE, _types.Location.STATS_BY, _types.Location.COMPLETION],
  validate: undefined,
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const inDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: 'in',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.in', {
    defaultMessage: 'The `IN` operator allows testing whether a field or expression equals an element in a list of literals, fields or expressions.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'boolean',
      optional: false
    }, {
      name: 'right',
      type: 'boolean[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_point',
      optional: false
    }, {
      name: 'right',
      type: 'cartesian_point[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_shape',
      optional: false
    }, {
      name: 'right',
      type: 'cartesian_shape[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'double[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'geo_point',
      optional: false
    }, {
      name: 'right',
      type: 'geo_point[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'geo_shape',
      optional: false
    }, {
      name: 'right',
      type: 'geo_shape[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'integer[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false
    }, {
      name: 'right',
      type: 'ip[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false
    }, {
      name: 'right',
      type: 'keyword[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false
    }, {
      name: 'right',
      type: 'text[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'long[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false
    }, {
      name: 'right',
      type: 'keyword[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false
    }, {
      name: 'right',
      type: 'text[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false
    }, {
      name: 'right',
      type: 'version[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }],
  locationsAvailable: [_types.Location.EVAL, _types.Location.WHERE, _types.Location.SORT, _types.Location.ROW, _types.Location.STATS_WHERE, _types.Location.COMPLETION],
  validate: undefined,
  examples: ['ROW a = 1, b = 4, c = 3\n| WHERE c-a IN (3, b / 2, a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const isNotNullDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: 'is not null',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.is_not_null', {
    defaultMessage: 'Returns `false` if the value is `NULL`, `true` otherwise.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'counter_double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'counter_integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'counter_long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.EVAL, _types.Location.WHERE, _types.Location.SORT, _types.Location.ROW, _types.Location.STATS_WHERE, _types.Location.COMPLETION],
  validate: undefined,
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const isNullDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: 'is null',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.is_null', {
    defaultMessage: 'Returns `true` if the value is `NULL`, `false` otherwise.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'counter_double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'counter_integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'counter_long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.EVAL, _types.Location.WHERE, _types.Location.SORT, _types.Location.ROW, _types.Location.STATS_WHERE, _types.Location.COMPLETION],
  validate: undefined,
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const lessThanDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: '<',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.less_than', {
    defaultMessage: 'Check if one field is less than another. If either field is multivalued then the result is `null`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'date',
      optional: false
    }, {
      name: 'right',
      type: 'date',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'right',
      type: 'date',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false
    }, {
      name: 'right',
      type: 'ip',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false
    }, {
      name: 'right',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false
    }, {
      name: 'right',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false
    }, {
      name: 'right',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false
    }, {
      name: 'right',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'right',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false
    }, {
      name: 'right',
      type: 'version',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'ip'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'version'
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_WHERE, _types.Location.STATS_BY, _types.Location.COMPLETION],
  validate: undefined,
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const lessThanOrEqualDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: '<=',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.less_than_or_equal', {
    defaultMessage: 'Check if one field is less than or equal to another. If either field is multivalued then the result is `null`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'date',
      optional: false
    }, {
      name: 'right',
      type: 'date',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'right',
      type: 'date',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false
    }, {
      name: 'right',
      type: 'ip',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false
    }, {
      name: 'right',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false
    }, {
      name: 'right',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false
    }, {
      name: 'right',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false
    }, {
      name: 'right',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'right',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false
    }, {
      name: 'right',
      type: 'version',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'ip'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'version'
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_WHERE, _types.Location.STATS_BY, _types.Location.COMPLETION],
  validate: undefined,
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const likeDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: 'like',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.like', {
    defaultMessage: 'Use `LIKE` to filter data based on string patterns using wildcards. `LIKE`\nusually acts on a field placed on the left-hand side of the operator, but it can\nalso act on a constant (literal) expression. The right-hand side of the operator\nrepresents the pattern or a list of patterns. If a list of patterns is provided,\nthe expression will return true if any of the patterns match.\n\nThe following wildcard characters are supported:\n\n* `*` matches zero or more characters.\n* `?` matches one character.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'str',
      type: 'keyword',
      optional: false
    }, {
      name: 'pattern',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'str',
      type: 'text',
      optional: false
    }, {
      name: 'pattern',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }],
  locationsAvailable: [_types.Location.EVAL, _types.Location.WHERE, _types.Location.SORT, _types.Location.ROW, _types.Location.STATS_WHERE, _types.Location.COMPLETION],
  validate: undefined,
  examples: ['FROM employees\n| WHERE first_name LIKE """?b*"""\n| KEEP first_name, last_name']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const matchOperatorDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: ':',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.match_operator', {
    defaultMessage: 'Use the match operator (`:`) to perform a match query on the specified field.\nUsing `:` is equivalent to using the `match` query in the Elasticsearch Query DSL.\n\nThe match operator is equivalent to the match function.\n\nFor using the function syntax, or adding match query parameters, you can use the\nmatch function.\n\n`:` returns true if the provided query matches the row.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'boolean',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'boolean',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'boolean',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'keyword',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'date',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'keyword',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'date_nanos',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'keyword',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'double',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'integer',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'keyword',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'long',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'double',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'integer',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'keyword',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'long',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'ip',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'keyword',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'keyword',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'double',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'integer',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'keyword',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'long',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'keyword',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'double',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'integer',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'keyword',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'long',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'unsigned_long',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'keyword',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false,
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'version',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.WHERE, _types.Location.STATS_WHERE],
  validate: undefined,
  examples: ['FROM books\n| WHERE author:"Faulkner"']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const modDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: '%',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.mod', {
    defaultMessage: 'Divide one number by another and return the remainder. If either field is multivalued then the result is `null`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'right',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_WHERE, _types.Location.STATS_BY, _types.Location.COMPLETION],
  validate: fnDef => {
    const [left, right] = fnDef.args;
    const messages = [];
    if (!Array.isArray(left) && !Array.isArray(right)) {
      if (right.type === 'literal' && (0, _esql_types.isNumericType)(right.literalType)) {
        if (right.value === 0) {
          messages.push({
            type: 'warning',
            code: 'moduleByZero',
            text: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.divide.warning.zeroModule', {
              defaultMessage: 'Module by zero can return null value: {left}%{right}',
              values: {
                left: left.text,
                right: right.value
              }
            }),
            location: fnDef.location
          });
        }
      }
    }
    return messages;
  },
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mulDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: '*',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.mul', {
    defaultMessage: 'Multiply two numbers together. If either field is multivalued then the result is `null`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'right',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_WHERE, _types.Location.STATS_BY, _types.Location.COMPLETION],
  validate: undefined,
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const negDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: '-',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.neg', {
    defaultMessage: 'Returns the negation of the argument.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'date_period',
      optional: false
    }],
    returnType: 'date_period'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'time_duration',
      optional: false
    }],
    returnType: 'time_duration'
  }],
  locationsAvailable: [_types.Location.STATS],
  validate: undefined,
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const notInDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: 'not in',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.not_in', {
    defaultMessage: 'The `NOT IN` operator allows testing whether a field or expression does *not* equal any element in a list of literals, fields or expressions.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'boolean',
      optional: false
    }, {
      name: 'right',
      type: 'boolean[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_point',
      optional: false
    }, {
      name: 'right',
      type: 'cartesian_point[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_shape',
      optional: false
    }, {
      name: 'right',
      type: 'cartesian_shape[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'double[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'geo_point',
      optional: false
    }, {
      name: 'right',
      type: 'geo_point[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'geo_shape',
      optional: false
    }, {
      name: 'right',
      type: 'geo_shape[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'integer[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false
    }, {
      name: 'right',
      type: 'ip[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false
    }, {
      name: 'right',
      type: 'keyword[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false
    }, {
      name: 'right',
      type: 'text[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'long[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false
    }, {
      name: 'right',
      type: 'keyword[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false
    }, {
      name: 'right',
      type: 'text[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false
    }, {
      name: 'right',
      type: 'version[]',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }],
  locationsAvailable: [_types.Location.EVAL, _types.Location.WHERE, _types.Location.SORT, _types.Location.ROW, _types.Location.STATS_WHERE, _types.Location.COMPLETION],
  validate: undefined,
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const notLikeDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: 'not like',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.not_like', {
    defaultMessage: 'Use `LIKE` to filter data based on string patterns using wildcards. `LIKE`\nusually acts on a field placed on the left-hand side of the operator, but it can\nalso act on a constant (literal) expression. The right-hand side of the operator\nrepresents the pattern or a list of patterns. If a list of patterns is provided,\nthe expression will return true if any of the patterns match.\n\nThe following wildcard characters are supported:\n\n* `*` matches zero or more characters.\n* `?` matches one character.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'str',
      type: 'keyword',
      optional: false
    }, {
      name: 'pattern',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'str',
      type: 'text',
      optional: false
    }, {
      name: 'pattern',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }],
  locationsAvailable: [_types.Location.EVAL, _types.Location.WHERE, _types.Location.SORT, _types.Location.ROW, _types.Location.STATS_WHERE, _types.Location.COMPLETION],
  validate: undefined,
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const notRlikeDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: 'not rlike',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.not_rlike', {
    defaultMessage: 'Use `RLIKE` to filter data based on string patterns using using\nregular expressions. `RLIKE` usually acts on a field placed on\nthe left-hand side of the operator, but it can also act on a constant (literal)\nexpression. The right-hand side of the operator represents the pattern.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'str',
      type: 'keyword',
      optional: false
    }, {
      name: 'pattern',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'str',
      type: 'text',
      optional: false
    }, {
      name: 'pattern',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }],
  locationsAvailable: [_types.Location.EVAL, _types.Location.WHERE, _types.Location.SORT, _types.Location.ROW, _types.Location.STATS_WHERE, _types.Location.COMPLETION],
  validate: undefined,
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const notEqualsDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: '!=',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.not_equals', {
    defaultMessage: 'Check if two fields are unequal. If either field is multivalued then the result is `null`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'boolean',
      optional: false
    }, {
      name: 'right',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_point',
      optional: false
    }, {
      name: 'right',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_shape',
      optional: false
    }, {
      name: 'right',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false
    }, {
      name: 'right',
      type: 'date',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'right',
      type: 'date',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geo_point',
      optional: false
    }, {
      name: 'right',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geo_shape',
      optional: false
    }, {
      name: 'right',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false
    }, {
      name: 'right',
      type: 'ip',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false
    }, {
      name: 'right',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false
    }, {
      name: 'right',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false
    }, {
      name: 'right',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false
    }, {
      name: 'right',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'right',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false
    }, {
      name: 'right',
      type: 'version',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'ip'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'version'
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_WHERE, _types.Location.STATS_BY, _types.Location.COMPLETION],
  validate: undefined,
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const rlikeDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: 'rlike',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.rlike', {
    defaultMessage: 'Use `RLIKE` to filter data based on string patterns using using\nregular expressions. `RLIKE` usually acts on a field placed on\nthe left-hand side of the operator, but it can also act on a constant (literal)\nexpression. The right-hand side of the operator represents the pattern.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'str',
      type: 'keyword',
      optional: false
    }, {
      name: 'pattern',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'str',
      type: 'text',
      optional: false
    }, {
      name: 'pattern',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }],
  locationsAvailable: [_types.Location.EVAL, _types.Location.WHERE, _types.Location.SORT, _types.Location.ROW, _types.Location.STATS_WHERE, _types.Location.COMPLETION],
  validate: undefined,
  examples: ['FROM employees\n| WHERE first_name RLIKE """.leja.*"""\n| KEEP first_name, last_name']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const subDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: '-',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.sub', {
    defaultMessage: 'Subtract one number from another. If either field is multivalued then the result is `null`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'date',
      optional: false
    }, {
      name: 'right',
      type: 'date_period',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false
    }, {
      name: 'right',
      type: 'time_duration',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'right',
      type: 'date_period',
      optional: false
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'right',
      type: 'time_duration',
      optional: false
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'left',
      type: 'date_period',
      optional: false
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'left',
      type: 'date_period',
      optional: false
    }, {
      name: 'right',
      type: 'date_period',
      optional: false
    }],
    returnType: 'date_period'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'integer',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }, {
      name: 'right',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'time_duration',
      optional: false
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'left',
      type: 'time_duration',
      optional: false
    }, {
      name: 'right',
      type: 'time_duration',
      optional: false
    }],
    returnType: 'time_duration'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'right',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }, {
    params: [{
      name: 'left',
      type: 'time_duration'
    }, {
      name: 'right',
      type: 'date'
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'left',
      type: 'date'
    }, {
      name: 'right',
      type: 'time_duration'
    }],
    returnType: 'date'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_WHERE, _types.Location.STATS_BY, _types.Location.COMPLETION],
  validate: undefined,
  examples: []
};
const operatorFunctionDefinitions = exports.operatorFunctionDefinitions = [addDefinition, divDefinition, equalsDefinition, greaterThanDefinition, greaterThanOrEqualDefinition, inDefinition, isNotNullDefinition, isNullDefinition, lessThanDefinition, lessThanOrEqualDefinition, likeDefinition, matchOperatorDefinition, modDefinition, mulDefinition, negDefinition, notInDefinition, notLikeDefinition, notRlikeDefinition, notEqualsDefinition, rlikeDefinition, subDefinition];