"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AIAssistantService = void 0;
exports.getResourceName = getResourceName;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _dataStreamAdapter = require("@kbn/data-stream-adapter");
var _coreSavedObjectsUtilsServer = require("@kbn/core-saved-objects-utils-server");
var _lodash = require("lodash");
var _inferenceCommon = require("@kbn/inference-common");
var _field_maps_configuration = require("../ai_assistant_data_clients/alert_summary/field_maps_configuration");
var _field_maps_configuration2 = require("../lib/attack_discovery/persistence/field_maps_configuration/field_maps_configuration");
var _field_maps_configuration3 = require("../lib/defend_insights/persistence/field_maps_configuration");
var _anonymization = require("../../common/anonymization");
var _conversations = require("../ai_assistant_data_clients/conversations");
var _create_resource_installation_helper = require("./create_resource_installation_helper");
var _field_maps_configuration4 = require("../ai_assistant_data_clients/conversations/field_maps_configuration");
var _field_maps_configuration5 = require("../ai_assistant_data_clients/prompts/field_maps_configuration");
var _field_maps_configuration6 = require("../ai_assistant_data_clients/anonymization_fields/field_maps_configuration");
var _ai_assistant_data_clients = require("../ai_assistant_data_clients");
var _field_maps_configuration7 = require("../ai_assistant_data_clients/knowledge_base/field_maps_configuration");
var _knowledge_base = require("../ai_assistant_data_clients/knowledge_base");
var _persistence = require("../lib/attack_discovery/persistence");
var _persistence2 = require("../lib/defend_insights/persistence");
var _helpers = require("./helpers");
var _helpers2 = require("../routes/helpers");
var _data_client = require("../lib/attack_discovery/schedules/data_client");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TOTAL_FIELDS_LIMIT = 2500;
function getResourceName(resource) {
  return `.kibana-elastic-ai-assistant-${resource}`;
}
class AIAssistantService {
  constructor(options) {
    (0, _defineProperty2.default)(this, "initialized", void 0);
    (0, _defineProperty2.default)(this, "isInitializing", false);
    (0, _defineProperty2.default)(this, "getElserId", void 0);
    (0, _defineProperty2.default)(this, "elserInferenceId", void 0);
    (0, _defineProperty2.default)(this, "conversationsDataStream", void 0);
    (0, _defineProperty2.default)(this, "knowledgeBaseDataStream", void 0);
    (0, _defineProperty2.default)(this, "promptsDataStream", void 0);
    (0, _defineProperty2.default)(this, "alertSummaryDataStream", void 0);
    (0, _defineProperty2.default)(this, "anonymizationFieldsDataStream", void 0);
    (0, _defineProperty2.default)(this, "attackDiscoveryDataStream", void 0);
    (0, _defineProperty2.default)(this, "defendInsightsDataStream", void 0);
    (0, _defineProperty2.default)(this, "resourceInitializationHelper", void 0);
    (0, _defineProperty2.default)(this, "initPromise", void 0);
    (0, _defineProperty2.default)(this, "isKBSetupInProgress", new Map());
    (0, _defineProperty2.default)(this, "hasInitializedV2KnowledgeBase", false);
    (0, _defineProperty2.default)(this, "productDocManager", void 0);
    (0, _defineProperty2.default)(this, "isProductDocumentationInProgress", false);
    (0, _defineProperty2.default)(this, "createDataStream", ({
      resource,
      kibanaVersion,
      fieldMap,
      settings,
      writeIndexOnly
    }) => {
      const newDataStream = new _dataStreamAdapter.DataStreamSpacesAdapter(this.resourceNames.aliases[resource], {
        kibanaVersion,
        totalFieldsLimit: TOTAL_FIELDS_LIMIT,
        writeIndexOnly
      });
      newDataStream.setComponentTemplate({
        name: this.resourceNames.componentTemplate[resource],
        fieldMap,
        settings
      });
      newDataStream.setIndexTemplate({
        name: this.resourceNames.indexTemplate[resource],
        componentTemplateRefs: [this.resourceNames.componentTemplate[resource]],
        // Apply `default_pipeline` if pipeline exists for resource
        ...(resource in this.resourceNames.pipelines &&
        // Remove this param and initialization when the `assistantKnowledgeBaseByDefault` feature flag is removed
        !(resource === 'knowledgeBase') ? {
          template: {
            settings: {
              'index.default_pipeline': this.resourceNames.pipelines[resource]
            }
          }
        } : {})
      });
      return newDataStream;
    });
    (0, _defineProperty2.default)(this, "resourceNames", {
      componentTemplate: {
        alertSummary: getResourceName('component-template-alert-summary'),
        conversations: getResourceName('component-template-conversations'),
        knowledgeBase: getResourceName('component-template-knowledge-base'),
        prompts: getResourceName('component-template-prompts'),
        anonymizationFields: getResourceName(_constants.ANONYMIZATION_FIELDS_COMPONENT_TEMPLATE),
        attackDiscovery: getResourceName('component-template-attack-discovery'),
        defendInsights: getResourceName('component-template-defend-insights')
      },
      aliases: {
        alertSummary: getResourceName('alert-summary'),
        conversations: getResourceName('conversations'),
        knowledgeBase: getResourceName('knowledge-base'),
        prompts: getResourceName('prompts'),
        anonymizationFields: getResourceName(_constants.ANONYMIZATION_FIELDS_RESOURCE),
        attackDiscovery: getResourceName('attack-discovery'),
        defendInsights: getResourceName('defend-insights')
      },
      indexPatterns: {
        alertSummary: getResourceName('alert-summary*'),
        conversations: getResourceName('conversations*'),
        knowledgeBase: getResourceName('knowledge-base*'),
        prompts: getResourceName('prompts*'),
        anonymizationFields: getResourceName(_constants.ANONYMIZATION_FIELDS_INDEX_PATTERN),
        attackDiscovery: getResourceName('attack-discovery*'),
        defendInsights: getResourceName('defend-insights*')
      },
      indexTemplate: {
        alertSummary: getResourceName('index-template-alert-summary'),
        conversations: getResourceName('index-template-conversations'),
        knowledgeBase: getResourceName('index-template-knowledge-base'),
        prompts: getResourceName('index-template-prompts'),
        anonymizationFields: getResourceName(_constants.ANONYMIZATION_FIELDS_INDEX_TEMPLATE),
        attackDiscovery: getResourceName('index-template-attack-discovery'),
        defendInsights: getResourceName('index-template-defend-insights')
      },
      pipelines: {
        knowledgeBase: getResourceName('ingest-pipeline-knowledge-base')
      }
    });
    this.options = options;
    this.initialized = false;
    this.getElserId = (0, _helpers.createGetElserId)(options.ml.trainedModelsProvider);
    this.elserInferenceId = options.elserInferenceId;
    this.conversationsDataStream = this.createDataStream({
      resource: 'conversations',
      kibanaVersion: options.kibanaVersion,
      fieldMap: _field_maps_configuration4.conversationsFieldMap
    });
    this.knowledgeBaseDataStream = this.createDataStream({
      resource: 'knowledgeBase',
      kibanaVersion: options.kibanaVersion,
      fieldMap: _field_maps_configuration7.knowledgeBaseFieldMap
    });
    this.promptsDataStream = this.createDataStream({
      resource: 'prompts',
      kibanaVersion: options.kibanaVersion,
      fieldMap: _field_maps_configuration5.assistantPromptsFieldMap
    });
    this.anonymizationFieldsDataStream = this.createDataStream({
      resource: 'anonymizationFields',
      kibanaVersion: options.kibanaVersion,
      fieldMap: _field_maps_configuration6.assistantAnonymizationFieldsFieldMap
    });
    this.attackDiscoveryDataStream = this.createDataStream({
      resource: 'attackDiscovery',
      kibanaVersion: options.kibanaVersion,
      fieldMap: _field_maps_configuration2.attackDiscoveryFieldMap
    });
    this.defendInsightsDataStream = this.createDataStream({
      resource: 'defendInsights',
      kibanaVersion: options.kibanaVersion,
      fieldMap: _field_maps_configuration3.defendInsightsFieldMap
    });
    this.alertSummaryDataStream = this.createDataStream({
      resource: 'alertSummary',
      kibanaVersion: options.kibanaVersion,
      fieldMap: _field_maps_configuration.alertSummaryFieldsFieldMap
    });
    this.initPromise = this.initializeResources();
    this.resourceInitializationHelper = (0, _create_resource_installation_helper.createResourceInstallationHelper)(this.options.logger, this.initPromise, this.installAndUpdateSpaceLevelResources.bind(this));
    options.productDocManager.then(productDocManager => {
      this.productDocManager = productDocManager;
    }).catch(error => {
      this.options.logger.warn(`Failed to initialize productDocManager: ${error.message}`);
    });
  }
  isInitialized() {
    return this.initialized;
  }
  getIsKBSetupInProgress(spaceId) {
    var _this$isKBSetupInProg;
    return (_this$isKBSetupInProg = this.isKBSetupInProgress.get(spaceId)) !== null && _this$isKBSetupInProg !== void 0 ? _this$isKBSetupInProg : false;
  }
  setIsKBSetupInProgress(spaceId, isInProgress) {
    this.isKBSetupInProgress.set(spaceId, isInProgress);
  }
  getIsProductDocumentationInProgress() {
    return this.isProductDocumentationInProgress;
  }
  setIsProductDocumentationInProgress(isInProgress) {
    this.isProductDocumentationInProgress = isInProgress;
  }
  async rolloverDataStream(initialInferenceEndpointId, targetInferenceEndpointId) {
    const esClient = await this.options.elasticsearchClientPromise;
    const currentDataStream = this.createDataStream({
      resource: 'knowledgeBase',
      kibanaVersion: this.options.kibanaVersion,
      fieldMap: {
        ...(0, _lodash.omit)(_field_maps_configuration7.knowledgeBaseFieldMap, 'semantic_text'),
        semantic_text: {
          type: 'semantic_text',
          array: false,
          required: false,
          inference_id: initialInferenceEndpointId,
          search_inference_id: targetInferenceEndpointId
        }
      }
    });

    // Add `search_inference_id` to the existing mappings
    await currentDataStream.install({
      esClient,
      logger: this.options.logger,
      pluginStop$: this.options.pluginStop$
    });

    // Migrate data stream mapping to the default inference_id
    const newDS = this.createDataStream({
      resource: 'knowledgeBase',
      kibanaVersion: this.options.kibanaVersion,
      fieldMap: {
        ...(0, _lodash.omit)(_field_maps_configuration7.knowledgeBaseFieldMap, ['semantic_text', 'vector', 'vector.tokens']),
        semantic_text: {
          type: 'semantic_text',
          array: false,
          required: false,
          ...(targetInferenceEndpointId !== _inferenceCommon.defaultInferenceEndpoints.ELSER ? {
            inference_id: targetInferenceEndpointId
          } : {})
        }
      },
      settings: {
        // force new semantic_text field behavior
        'index.mapping.semantic_text.use_legacy_format': false
      },
      writeIndexOnly: true
    });

    // We need to first install the templates and then rollover the indices
    await newDS.installTemplates({
      esClient,
      logger: this.options.logger,
      pluginStop$: this.options.pluginStop$
    });
    const indexNames = (await esClient.indices.getDataStream({
      name: newDS.name
    })).data_streams.map(ds => ds.name);
    try {
      await Promise.all(indexNames.map(indexName => esClient.indices.rollover({
        alias: indexName
      })));
    } catch (e) {
      /* empty */
    }
    return newDS;
  }
  async initializeResources() {
    this.isInitializing = true;
    try {
      var _await$esClient$indic;
      this.options.logger.debug(`Initializing resources for AIAssistantService`);
      const esClient = await this.options.elasticsearchClientPromise;
      if (this.productDocManager) {
        // install product documentation without blocking other resources
        void (0, _helpers.ensureProductDocumentationInstalled)({
          productDocManager: this.productDocManager,
          logger: this.options.logger,
          setIsProductDocumentationInProgress: this.setIsProductDocumentationInProgress.bind(this)
        });
      }
      await this.conversationsDataStream.install({
        esClient,
        logger: this.options.logger,
        pluginStop$: this.options.pluginStop$
      });
      const knowledgeBaseDataSteams = (_await$esClient$indic = await esClient.indices.getDataStream({
        name: this.knowledgeBaseDataStream.name
      })) === null || _await$esClient$indic === void 0 ? void 0 : _await$esClient$indic.data_streams;
      let mappings = [];
      try {
        mappings = await Promise.all(knowledgeBaseDataSteams.map(ds => esClient.indices.simulateTemplate({
          name: ds.template
        })));
      } catch (error) {
        /* empty */
      }
      const isUsingDedicatedInferenceEndpoint = (0, _lodash.some)(mappings, value => {
        var _value$template, _value$template$mappi, _value$template$mappi2, _value$template$mappi3;
        return (value === null || value === void 0 ? void 0 : (_value$template = value.template) === null || _value$template === void 0 ? void 0 : (_value$template$mappi = _value$template.mappings) === null || _value$template$mappi === void 0 ? void 0 : (_value$template$mappi2 = _value$template$mappi.properties) === null || _value$template$mappi2 === void 0 ? void 0 : (_value$template$mappi3 = _value$template$mappi2.semantic_text) === null || _value$template$mappi3 === void 0 ? void 0 : _value$template$mappi3.inference_id) === _field_maps_configuration7.ASSISTANT_ELSER_INFERENCE_ID;
      });
      if (isUsingDedicatedInferenceEndpoint) {
        this.knowledgeBaseDataStream = await this.rolloverDataStream(_field_maps_configuration7.ASSISTANT_ELSER_INFERENCE_ID, _inferenceCommon.defaultInferenceEndpoints.ELSER);
      } else {
        // We need to make sure that the data stream is created with the correct mappings
        this.knowledgeBaseDataStream = this.createDataStream({
          resource: 'knowledgeBase',
          kibanaVersion: this.options.kibanaVersion,
          fieldMap: {
            ...(0, _lodash.omit)(_field_maps_configuration7.knowledgeBaseFieldMap, ['semantic_text', 'vector', 'vector.tokens']),
            semantic_text: {
              type: 'semantic_text',
              array: false,
              required: false,
              ...(this.elserInferenceId ? {
                inference_id: this.elserInferenceId
              } : {})
            }
          },
          writeIndexOnly: true
        });
      }
      const soClient = await this.options.soClientPromise;
      await (0, _knowledge_base.ensureDedicatedInferenceEndpoint)({
        elserId: await this.getElserId(),
        esClient,
        getTrainedModelsProvider: () => this.options.ml.trainedModelsProvider({}, soClient),
        logger: this.options.logger,
        index: this.knowledgeBaseDataStream.name
      });
      await this.knowledgeBaseDataStream.install({
        esClient,
        logger: this.options.logger,
        pluginStop$: this.options.pluginStop$
      });
      await this.promptsDataStream.install({
        esClient,
        logger: this.options.logger,
        pluginStop$: this.options.pluginStop$
      });
      await this.anonymizationFieldsDataStream.install({
        esClient,
        logger: this.options.logger,
        pluginStop$: this.options.pluginStop$
      });
      await this.attackDiscoveryDataStream.install({
        esClient,
        logger: this.options.logger,
        pluginStop$: this.options.pluginStop$
      });
      await this.defendInsightsDataStream.install({
        esClient,
        logger: this.options.logger,
        pluginStop$: this.options.pluginStop$
      });
      await this.alertSummaryDataStream.install({
        esClient,
        logger: this.options.logger,
        pluginStop$: this.options.pluginStop$
      });
    } catch (error) {
      this.options.logger.warn(`Error initializing AI assistant resources: ${error.message}`);
      this.initialized = false;
      this.isInitializing = false;
      return (0, _create_resource_installation_helper.errorResult)(error.message);
    }
    this.initialized = true;
    this.isInitializing = false;
    return (0, _create_resource_installation_helper.successResult)();
  }
  async checkResourcesInstallation(opts) {
    const licensing = await opts.licensing;
    if (!(0, _helpers2.hasAIAssistantLicense)(licensing.license)) return null;
    // Check if resources installation has succeeded
    const {
      result: initialized,
      error
    } = await this.getSpaceResourcesInitializationPromise(opts.spaceId);

    // If space level resources initialization failed, retry
    if (!initialized && error) {
      var _opts$spaceId;
      let initRetryPromise;

      // If !this.initialized, we know that resource initialization failed
      // and we need to retry this before retrying the spaceId specific resources
      if (!this.initialized) {
        if (!this.isInitializing) {
          this.options.logger.info(`Retrying common resource initialization`);
          initRetryPromise = this.initializeResources();
        } else {
          this.options.logger.info(`Skipped retrying common resource initialization because it is already being retried.`);
        }
      }
      this.resourceInitializationHelper.retry(opts.spaceId, initRetryPromise);
      const retryResult = await this.resourceInitializationHelper.getInitializedResources((_opts$spaceId = opts.spaceId) !== null && _opts$spaceId !== void 0 ? _opts$spaceId : _coreSavedObjectsUtilsServer.DEFAULT_NAMESPACE_STRING);
      if (!retryResult.result) {
        const errorLogPrefix = `There was an error in the framework installing spaceId-level resources and creating concrete indices for spaceId "${opts.spaceId}" - `;
        // Retry also failed
        this.options.logger.warn(retryResult.error && error ? `${errorLogPrefix}Retry failed with errors: ${error}` : `${errorLogPrefix}Original error: ${error}; Error after retry: ${retryResult.error}`);
        return null;
      } else {
        this.options.logger.info(`Resource installation for "${opts.spaceId}" succeeded after retry`);
      }
    }
  }
  async getProductDocumentationStatus() {
    var _this$productDocManag;
    const status = await ((_this$productDocManag = this.productDocManager) === null || _this$productDocManag === void 0 ? void 0 : _this$productDocManag.getStatus({
      inferenceId: _inferenceCommon.defaultInferenceEndpoints.ELSER
    }));
    if (!status) {
      return 'uninstalled';
    }
    return this.isProductDocumentationInProgress ? 'installing' : status.status;
  }
  async createAIAssistantConversationsDataClient(opts) {
    const res = await this.checkResourcesInstallation(opts);
    if (res === null) {
      return null;
    }
    return new _conversations.AIAssistantConversationsDataClient({
      logger: this.options.logger,
      elasticsearchClientPromise: this.options.elasticsearchClientPromise,
      spaceId: opts.spaceId,
      kibanaVersion: this.options.kibanaVersion,
      indexPatternsResourceName: this.resourceNames.aliases.conversations,
      currentUser: opts.currentUser
    });
  }
  async createAIAssistantKnowledgeBaseDataClient(opts) {
    var _opts$manageGlobalKno;
    // If a V2 KnowledgeBase has never been initialized we need to reinitialize all persistence resources to make sure
    // they're using the correct model/mappings. Technically all existing KB data is stale since it was created
    // with a different model/mappings.
    // Added hasInitializedV2KnowledgeBase to prevent the console noise from re-init on each KB request
    if (!this.hasInitializedV2KnowledgeBase) {
      await this.initializeResources();
      this.hasInitializedV2KnowledgeBase = true;
    }
    const res = await this.checkResourcesInstallation(opts);
    if (res === null) {
      return null;
    }
    return new _knowledge_base.AIAssistantKnowledgeBaseDataClient({
      logger: this.options.logger.get('knowledgeBase'),
      currentUser: opts.currentUser,
      elasticsearchClientPromise: this.options.elasticsearchClientPromise,
      indexPatternsResourceName: this.resourceNames.aliases.knowledgeBase,
      ingestPipelineResourceName: this.resourceNames.pipelines.knowledgeBase,
      getElserId: this.getElserId,
      getIsKBSetupInProgress: this.getIsKBSetupInProgress.bind(this),
      getProductDocumentationStatus: this.getProductDocumentationStatus.bind(this),
      kibanaVersion: this.options.kibanaVersion,
      ml: this.options.ml,
      elserInferenceId: this.options.elserInferenceId,
      setIsKBSetupInProgress: this.setIsKBSetupInProgress.bind(this),
      spaceId: opts.spaceId,
      manageGlobalKnowledgeBaseAIAssistant: (_opts$manageGlobalKno = opts.manageGlobalKnowledgeBaseAIAssistant) !== null && _opts$manageGlobalKno !== void 0 ? _opts$manageGlobalKno : false,
      getTrainedModelsProvider: opts.getTrainedModelsProvider
    });
  }
  async createAttackDiscoveryDataClient(opts) {
    const res = await this.checkResourcesInstallation(opts);
    if (res === null) {
      return null;
    }
    return new _persistence.AttackDiscoveryDataClient({
      adhocAttackDiscoveryDataClient: opts.adhocAttackDiscoveryDataClient,
      logger: this.options.logger.get('attackDiscovery'),
      currentUser: opts.currentUser,
      elasticsearchClientPromise: this.options.elasticsearchClientPromise,
      indexPatternsResourceName: this.resourceNames.aliases.attackDiscovery,
      kibanaVersion: this.options.kibanaVersion,
      spaceId: opts.spaceId
    });
  }
  async createAttackDiscoverySchedulingDataClient(opts) {
    return new _data_client.AttackDiscoveryScheduleDataClient({
      actionsClient: opts.actionsClient,
      logger: opts.logger,
      rulesClient: opts.rulesClient
    });
  }
  async createDefendInsightsDataClient(opts) {
    const res = await this.checkResourcesInstallation(opts);
    if (res === null) {
      return null;
    }
    return new _persistence2.DefendInsightsDataClient({
      logger: this.options.logger.get('defendInsights'),
      currentUser: opts.currentUser,
      elasticsearchClientPromise: this.options.elasticsearchClientPromise,
      indexPatternsResourceName: this.resourceNames.aliases.defendInsights,
      kibanaVersion: this.options.kibanaVersion,
      spaceId: opts.spaceId
    });
  }
  async createAIAssistantPromptsDataClient(opts) {
    const res = await this.checkResourcesInstallation(opts);
    if (res === null) {
      return null;
    }
    return new _ai_assistant_data_clients.AIAssistantDataClient({
      logger: this.options.logger,
      elasticsearchClientPromise: this.options.elasticsearchClientPromise,
      spaceId: opts.spaceId,
      kibanaVersion: this.options.kibanaVersion,
      indexPatternsResourceName: this.resourceNames.aliases.prompts,
      currentUser: opts.currentUser
    });
  }
  async createAlertSummaryDataClient(opts) {
    const res = await this.checkResourcesInstallation(opts);
    if (res === null) {
      return null;
    }
    return new _ai_assistant_data_clients.AIAssistantDataClient({
      logger: this.options.logger,
      elasticsearchClientPromise: this.options.elasticsearchClientPromise,
      spaceId: opts.spaceId,
      kibanaVersion: this.options.kibanaVersion,
      indexPatternsResourceName: this.resourceNames.aliases.alertSummary,
      currentUser: opts.currentUser
    });
  }
  async createAIAssistantAnonymizationFieldsDataClient(opts) {
    const res = await this.checkResourcesInstallation(opts);
    if (res === null) {
      return null;
    }
    return new _ai_assistant_data_clients.AIAssistantDataClient({
      logger: this.options.logger,
      elasticsearchClientPromise: this.options.elasticsearchClientPromise,
      spaceId: opts.spaceId,
      kibanaVersion: this.options.kibanaVersion,
      indexPatternsResourceName: this.resourceNames.aliases.anonymizationFields,
      currentUser: opts.currentUser
    });
  }
  async getSpaceResourcesInitializationPromise(spaceId = _coreSavedObjectsUtilsServer.DEFAULT_NAMESPACE_STRING) {
    const result = await this.resourceInitializationHelper.getInitializedResources(spaceId);
    // If the spaceId is unrecognized and spaceId is not the default, we
    // need to kick off resource installation and return the promise
    if (result.error && result.error.includes(`Unrecognized spaceId`) && spaceId !== _coreSavedObjectsUtilsServer.DEFAULT_NAMESPACE_STRING) {
      this.resourceInitializationHelper.add(spaceId);
      return this.resourceInitializationHelper.getInitializedResources(spaceId);
    }
    return result;
  }
  async installAndUpdateSpaceLevelResources(spaceId = _coreSavedObjectsUtilsServer.DEFAULT_NAMESPACE_STRING) {
    try {
      this.options.logger.debug(`Initializing spaceId level resources for AIAssistantService`);
      const conversationsIndexName = await this.conversationsDataStream.getInstalledSpaceName(spaceId);
      if (!conversationsIndexName) {
        await this.conversationsDataStream.installSpace(spaceId);
      }
      const knowledgeBaseIndexName = await this.knowledgeBaseDataStream.getInstalledSpaceName(spaceId);
      if (!knowledgeBaseIndexName) {
        await this.knowledgeBaseDataStream.installSpace(spaceId);
      }
      const promptsIndexName = await this.promptsDataStream.getInstalledSpaceName(spaceId);
      if (!promptsIndexName) {
        await this.promptsDataStream.installSpace(spaceId);
      }
      const anonymizationFieldsIndexName = await this.anonymizationFieldsDataStream.getInstalledSpaceName(spaceId);
      if (!anonymizationFieldsIndexName) {
        await this.anonymizationFieldsDataStream.installSpace(spaceId);
        await this.createDefaultAnonymizationFields(spaceId);
      }
      const alertSummaryIndexName = await this.alertSummaryDataStream.getInstalledSpaceName(spaceId);
      if (!alertSummaryIndexName) {
        await this.alertSummaryDataStream.installSpace(spaceId);
      }
    } catch (error) {
      this.options.logger.warn(`Error initializing AI assistant namespace level resources: ${error.message}`);
      throw error;
    }
  }
  async createDefaultAnonymizationFields(spaceId) {
    const dataClient = new _ai_assistant_data_clients.AIAssistantDataClient({
      logger: this.options.logger,
      elasticsearchClientPromise: this.options.elasticsearchClientPromise,
      spaceId,
      kibanaVersion: this.options.kibanaVersion,
      indexPatternsResourceName: this.resourceNames.aliases.anonymizationFields,
      currentUser: null
    });
    const existingAnonymizationFields = await (await (dataClient === null || dataClient === void 0 ? void 0 : dataClient.getReader())).search({
      size: 1,
      allow_no_indices: true
    });
    if (existingAnonymizationFields.hits.total.value === 0) {
      const writer = await (dataClient === null || dataClient === void 0 ? void 0 : dataClient.getWriter());
      const res = await (writer === null || writer === void 0 ? void 0 : writer.bulk({
        documentsToCreate: (0, _anonymization.getDefaultAnonymizationFields)(spaceId)
      }));
      this.options.logger.info(`Created default anonymization fields: ${res === null || res === void 0 ? void 0 : res.docs_created.length}`);
    }
  }
}
exports.AIAssistantService = AIAssistantService;