"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setBreadcrumbs = exports.listBreadcrumb = exports.init = exports.editBreadcrumb = exports.addBreadcrumb = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let setBreadcrumbs = exports.setBreadcrumbs = void 0;
const init = _setBreadcrumbs => {
  exports.setBreadcrumbs = setBreadcrumbs = _setBreadcrumbs;
};
exports.init = init;
const listBreadcrumb = section => {
  return {
    text: _i18n.i18n.translate('xpack.crossClusterReplication.homeBreadcrumbTitle', {
      defaultMessage: 'Cross-Cluster Replication'
    }),
    href: section || '/'
  };
};
exports.listBreadcrumb = listBreadcrumb;
const addBreadcrumb = exports.addBreadcrumb = {
  text: _i18n.i18n.translate('xpack.crossClusterReplication.addBreadcrumbTitle', {
    defaultMessage: 'Add'
  })
};
const editBreadcrumb = exports.editBreadcrumb = {
  text: _i18n.i18n.translate('xpack.crossClusterReplication.editBreadcrumbTitle', {
    defaultMessage: 'Edit'
  })
};