"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PricingService = void 0;
var _corePricingCommon = require("@kbn/core-pricing-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const defaultPricingResponse = {
  tiers: {
    enabled: false,
    products: []
  },
  product_features: {}
};

/**
 * Service that is responsible for UI Pricing.
 * @internal
 */
class PricingService {
  async start({
    http
  }) {
    const isAnonymous = http.anonymousPaths.isAnonymous(window.location.pathname);
    const pricingResponse = isAnonymous ? defaultPricingResponse : await http.get('/internal/core/pricing');
    const tiersClient = new _corePricingCommon.PricingTiersClient(pricingResponse.tiers, new _corePricingCommon.ProductFeaturesRegistry(pricingResponse.product_features));
    return {
      isFeatureAvailable: tiersClient.isFeatureAvailable
    };
  }
}
exports.PricingService = PricingService;