"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesSettingsClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rules_settings_flapping_client = require("./flapping/rules_settings_flapping_client");
var _rules_settings_query_delay_client = require("./query_delay/rules_settings_query_delay_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RulesSettingsClient {
  constructor(options) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "savedObjectsClient", void 0);
    (0, _defineProperty2.default)(this, "getUserName", void 0);
    (0, _defineProperty2.default)(this, "_flapping", void 0);
    (0, _defineProperty2.default)(this, "_queryDelay", void 0);
    (0, _defineProperty2.default)(this, "isServerless", void 0);
    this.logger = options.logger;
    this.savedObjectsClient = options.savedObjectsClient;
    this.getUserName = options.getUserName;
    this.isServerless = options.isServerless;
    this._flapping = new _rules_settings_flapping_client.RulesSettingsFlappingClient({
      logger: this.logger,
      savedObjectsClient: this.savedObjectsClient,
      getModificationMetadata: this.getModificationMetadata.bind(this)
    });
    this._queryDelay = new _rules_settings_query_delay_client.RulesSettingsQueryDelayClient({
      logger: this.logger,
      savedObjectsClient: this.savedObjectsClient,
      isServerless: this.isServerless,
      getModificationMetadata: this.getModificationMetadata.bind(this)
    });
  }
  async getModificationMetadata() {
    const createTime = Date.now();
    const userName = await this.getUserName();
    return {
      createdBy: userName,
      updatedBy: userName,
      createdAt: new Date(createTime).toISOString(),
      updatedAt: new Date(createTime).toISOString()
    };
  }
  flapping() {
    return this._flapping;
  }
  queryDelay() {
    return this._queryDelay;
  }
}
exports.RulesSettingsClient = RulesSettingsClient;