"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._EuiPageTemplate = exports.TemplateContext = exports.EuiPageTemplate = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _outer = require("./outer");
var _inner = require("./inner");
var _page_bottom_bar = require("./bottom_bar/page_bottom_bar");
var _page_empty_prompt = require("./empty_prompt/page_empty_prompt");
var _page = require("../page");
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _react2 = require("@emotion/react");
var _excluded = ["children", "responsive", "restrictWidth", "paddingSize", "grow", "bottomBorder", "offset", "panelled", "contentBorder", "component", "mainProps", "className", "minHeight", "style"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var TemplateContext = exports.TemplateContext = /*#__PURE__*/(0, _react.createContext)({
  sidebar: {},
  section: {},
  header: {},
  emptyPrompt: {},
  bottomBar: {}
});
/**
 * Consumed via `EuiPageTemplate`,
 * it controls and propogates most of the shared props per direct child
 */
var _EuiPageTemplate = exports._EuiPageTemplate = function _EuiPageTemplate(_ref) {
  var children = _ref.children,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? ['xs', 's'] : _ref$responsive,
    _ref$restrictWidth = _ref.restrictWidth,
    restrictWidth = _ref$restrictWidth === void 0 ? true : _ref$restrictWidth,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    bottomBorder = _ref.bottomBorder,
    offset = _ref.offset,
    panelled = _ref.panelled,
    contentBorder = _ref.contentBorder,
    component = _ref.component,
    mainProps = _ref.mainProps,
    className = _ref.className,
    _ref$minHeight = _ref.minHeight,
    minHeight = _ref$minHeight === void 0 ? '460px' : _ref$minHeight,
    style = _ref.style,
    rest = _objectWithoutProperties(_ref, _excluded);
  // Used as a target to insert the bottom bar component
  var pageInnerId = (0, _services.useGeneratedHtmlId)({
    prefix: 'EuiPageTemplateInner',
    conditionalId: mainProps === null || mainProps === void 0 ? void 0 : mainProps.id
  });

  // Sections include page header
  var _useMemo = (0, _react.useMemo)(function () {
      var sidebar = [];
      var sections = [];
      _react.default.Children.toArray(children).forEach(function (child) {
        if (! /*#__PURE__*/_react.default.isValidElement(child)) return; // Skip non-components

        if (child.type === _EuiPageSidebar || child.props.__EMOTION_TYPE_PLEASE_DO_NOT_USE__ === _EuiPageSidebar) {
          sidebar.push(child);
        } else {
          sections.push(child);
        }
      });
      return [sidebar, sections];
    }, [children]),
    _useMemo2 = _slicedToArray(_useMemo, 2),
    sidebar = _useMemo2[0],
    sections = _useMemo2[1];
  var classes = (0, _classnames.default)('euiPageTemplate', className);
  var pageStyle = (0, _react.useMemo)(function () {
    return (0, _global_styling.logicalStyles)(_objectSpread({
      minHeight: grow ? "max(".concat(minHeight, ", 100vh)") : minHeight,
      paddingTop: offset !== null && offset !== void 0 ? offset : 'var(--euiFixedHeadersOffset, 0)'
    }, style));
  }, [minHeight, grow, offset, style]);
  var innerPanelled = panelled !== null && panelled !== void 0 ? panelled : Boolean(sidebar.length > 0);
  var innerBordered = contentBorder !== null && contentBorder !== void 0 ? contentBorder : Boolean(sidebar.length > 0);
  var headerBottomBorder = bottomBorder !== null && bottomBorder !== void 0 ? bottomBorder : sidebar.length ? true : 'extended';
  var templateContext = (0, _react.useMemo)(function () {
    return {
      sidebar: {
        paddingSize: paddingSize,
        responsive: responsive
      },
      header: {
        restrictWidth: restrictWidth,
        paddingSize: paddingSize,
        bottomBorder: headerBottomBorder
      },
      section: {
        restrictWidth: restrictWidth,
        paddingSize: paddingSize,
        color: panelled === false ? 'transparent' : 'plain',
        grow: true
      },
      emptyPrompt: {
        panelled: innerPanelled ? true : panelled,
        grow: true
      },
      bottomBar: {
        restrictWidth: restrictWidth,
        paddingSize: paddingSize,
        // pageInnerId may contain colons that are parsed as pseudo-elements if not escaped
        parent: "#".concat(pageInnerId.replaceAll(':', '\\:'))
      }
    };
  }, [pageInnerId, restrictWidth, responsive, paddingSize, panelled, innerPanelled, headerBottomBorder]);
  return (0, _react2.jsx)(TemplateContext.Provider, {
    value: templateContext
  }, (0, _react2.jsx)(_outer._EuiPageOuter, _extends({}, rest, {
    responsive: responsive,
    style: pageStyle,
    className: classes
  }), sidebar, (0, _react2.jsx)(_inner._EuiPageInner, _extends({}, mainProps, {
    component: component,
    id: pageInnerId,
    border: innerBordered,
    panelled: innerPanelled,
    responsive: responsive
  }), sections)));
};
_EuiPageTemplate.propTypes = {
  /**
     * Adds `flex-grow: 1` to the whole page for stretching to fit vertically.
     * Must be wrapped inside a flexbox, preferrably with `min-height: 100vh`
     */
  grow: _propTypes.default.bool,
  /**
     * Changes the `flex-direction` property.
     * Flip to `column` when not including a sidebar.
     */
  direction: _propTypes.default.any,
  /**
         * Decides at which point the main content wrapper will be 100vw.
         */
  /**
     * When direction is `row`, it will flip to `column` when within these breakpoints.
     */
  responsive: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
  className: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string]),
  "aria-label": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string]),
  "data-test-subj": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string]),
  css: _propTypes.default.oneOfType([_propTypes.default.any, _propTypes.default.any]),
  /**
         * Adds a white background and shadow to define the area.
         */
  panelled: _propTypes.default.bool,
  /**
         * Adjust the overall padding.
         */
  paddingSize: _propTypes.default.any,
  /**
     * Sets the max-width of the page,
     * set to `true` to use the default size of `1200px`,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  restrictWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),
  /**
     * Adds a bottom border to separate it from the content after;
     * Passing `extended` will ensure the border touches the sides of the parent container.
     */
  bottomBorder: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["extended"])]),
  /**
       * Applies a top or left border to the inner contents
       * to add separation between content and sidebar when a sidebar exists.
       */
  contentBorder: _propTypes.default.any,
  /**
       * Minimum height in which to enforce scrolling
       */
  minHeight: _propTypes.default.any,
  /**
       * To account for any fixed elements like headers,
       * pass in the value of the total height of those fixed elements.
       * Otherwise they will be calculated based on the data attributes on the body element.
       */
  offset: _propTypes.default.number,
  /**
       * Passes through some common HTML attributes to the `main` content wrapper
       */
  mainProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }),
  /**
       * Sets which HTML element to render for the `main` content wrapper
       * @default main
       */
  component: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.elementType.isRequired])
};
var _EuiPageSidebar = function _EuiPageSidebar(props) {
  var _useContext = (0, _react.useContext)(TemplateContext),
    sidebar = _useContext.sidebar;
  return (0, _react2.jsx)(_page.EuiPageSidebar, _extends({}, sidebar, props));
};
_EuiPageSidebar.propTypes = {
  /**
     * Adjust the padding.
     * When using this setting it's best to be consistent throughout all similar usages.
     */
  paddingSize: _propTypes.default.any,
  /**
     * Renders a fancy little visual in the top left corner of the side bar
     */
  hasEmbellish: _propTypes.default.bool,
  /**
     * Adds `position: sticky` and affords for any fixed position headers.
     */
  sticky: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.shape({
    /**
             * To account for any fixed elements like headers,
             * pass in the value of the total height of those fixed elements.
             */
    offset: _propTypes.default.number
  }).isRequired]),
  /**
     * A minimum width is necessary to maintain size.
     * Be sure to take `paddingSize` into account.
     */
  minWidth: _propTypes.default.any,
  /**
     * Sets the `minWidth` to 100% when within these breakpoints.
     */
  responsive: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};
var _EuiPageSection = function _EuiPageSection(props) {
  var _useContext2 = (0, _react.useContext)(TemplateContext),
    section = _useContext2.section;
  return (0, _react2.jsx)(_page.EuiPageSection, _extends({}, section, props));
};
_EuiPageSection.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * Sets the max-width of the page,
     * set to `true` to use the default size of `1200px`,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  restrictWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),
  /**
       * Background color of the section;
       * Usually a lightened form of the brand colors
       */
  color: _propTypes.default.any,
  /**
       * Padding for all four sides
       */
  paddingSize: _propTypes.default.any,
  /**
       * Horizontal and/or vertical alignment of the section contents
       */
  alignment: _propTypes.default.any,
  /**
       * When true the panel will grow in height to fill container if parent is a flex group
       */
  grow: _propTypes.default.bool,
  /**
       * Passed down to the div wrapper of the section contents
       */
  contentProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }),
  /**
       * Sets which HTML element to render.
       */
  component: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.elementType.isRequired])
};
var _EuiPageHeader = function _EuiPageHeader(props) {
  var _useContext3 = (0, _react.useContext)(TemplateContext),
    header = _useContext3.header;
  return (0, _react2.jsx)(_page.EuiPageHeader, _extends({}, header, props));
};
_EuiPageHeader.propTypes = {
  /**
     * Adjust the overall padding.
     */
  paddingSize: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * Sets the max-width of the page,
     * set to `true` to use the default size of `1200px`,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  restrictWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),
  /**
     * Adds a bottom border to separate it from the content after;
     * Passing `extended` will ensure the border touches the sides of the parent container.
     */
  bottomBorder: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["extended"])])
};
var _EuiPageEmptyPrompt = function _EuiPageEmptyPrompt(props) {
  var _useContext4 = (0, _react.useContext)(TemplateContext),
    emptyPrompt = _useContext4.emptyPrompt;
  return (0, _react2.jsx)(_page_empty_prompt._EuiPageEmptyPrompt, _extends({}, emptyPrompt, props));
};
_EuiPageEmptyPrompt.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  restrictWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),
  color: _propTypes.default.any,
  paddingSize: _propTypes.default.any,
  alignment: _propTypes.default.any,
  grow: _propTypes.default.bool,
  contentProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }),
  component: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.elementType.isRequired]),
  panelled: _propTypes.default.bool
};
var _EuiPageBottomBar = function _EuiPageBottomBar(props) {
  var _useContext5 = (0, _react.useContext)(TemplateContext),
    bottomBar = _useContext5.bottomBar;
  return (0, _react2.jsx)(_page_bottom_bar._EuiPageBottomBar, _extends({}, bottomBar, props));
};
_EuiPageBottomBar.propTypes = {
  /**
     * The reference id of the element to insert into
     */
  parent: _propTypes.default.string,
  /**
     * Sets the max-width of the page,
     * set to `true` to use the default size of `1200px`,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  restrictWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired])
};
var EuiPageTemplate = exports.EuiPageTemplate = Object.assign(_EuiPageTemplate, {
  Sidebar: _EuiPageSidebar,
  Header: _EuiPageHeader,
  Section: _EuiPageSection,
  BottomBar: _EuiPageBottomBar,
  EmptyPrompt: _EuiPageEmptyPrompt
});