"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _react = _interopRequireWildcard(require("react"));
var _key_pad_menu = require("./key_pad_menu");
var _key_pad_menu_item = require("./key_pad_menu_item");
var _icon = require("../icon");
var _services = require("../../services");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />
var KeyPadMenu = function KeyPadMenu() {
  var keypadButtonId__1 = (0, _services.useGeneratedHtmlId)({
    prefix: 'keypadButton',
    suffix: 'first'
  });
  var keypadButtonId__2 = (0, _services.useGeneratedHtmlId)({
    prefix: 'keypadButton',
    suffix: 'second'
  });
  var keypadButtonId__3 = (0, _services.useGeneratedHtmlId)({
    prefix: 'keypadButton',
    suffix: 'third'
  });
  var keypadButtonId__4 = (0, _services.useGeneratedHtmlId)({
    prefix: 'keypadButton',
    suffix: 'fourth'
  });
  var keypadButtonId__5 = (0, _services.useGeneratedHtmlId)({
    prefix: 'keypadButton',
    suffix: 'fifth'
  });
  var keypadButtonId__6 = (0, _services.useGeneratedHtmlId)({
    prefix: 'keypadButton',
    suffix: 'sixth'
  });
  var _useState = (0, _react.useState)(keypadButtonId__6),
    _useState2 = _slicedToArray(_useState, 2),
    selectedID = _useState2[0],
    setSelectedID = _useState2[1];
  return (0, _react2.jsx)("div", {
    "aria-label": "Menu keypad"
  }, (0, _react2.jsx)(_key_pad_menu.EuiKeyPadMenu, null, (0, _react2.jsx)(_key_pad_menu_item.EuiKeyPadMenuItem, {
    "data-test-subj": "cy-keypad-button-1",
    id: keypadButtonId__1,
    label: "Button 1",
    isSelected: selectedID === keypadButtonId__1,
    onClick: function onClick() {
      return setSelectedID(keypadButtonId__1);
    }
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "grid",
    size: "l"
  })), (0, _react2.jsx)(_key_pad_menu_item.EuiKeyPadMenuItem, {
    "data-test-subj": "cy-keypad-button-2",
    id: keypadButtonId__2,
    label: "Button 2",
    isSelected: selectedID === keypadButtonId__2,
    onClick: function onClick() {
      return setSelectedID(keypadButtonId__2);
    }
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "grid",
    size: "l"
  })), (0, _react2.jsx)(_key_pad_menu_item.EuiKeyPadMenuItem, {
    "data-test-subj": "cy-keypad-button-3",
    id: keypadButtonId__3,
    label: "Button 3",
    isSelected: selectedID === keypadButtonId__3,
    onClick: function onClick() {
      return setSelectedID(keypadButtonId__3);
    }
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "grid",
    size: "l"
  })), (0, _react2.jsx)(_key_pad_menu_item.EuiKeyPadMenuItem, {
    "data-test-subj": "cy-keypad-link-1",
    id: keypadButtonId__4,
    label: "Link 1",
    href: "#/navigation/key-pad-menu",
    isSelected: selectedID === keypadButtonId__4,
    onClick: function onClick() {
      return setSelectedID(keypadButtonId__4);
    }
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "link",
    size: "l"
  })), (0, _react2.jsx)(_key_pad_menu_item.EuiKeyPadMenuItem, {
    "data-test-subj": "cy-keypad-link-2",
    id: keypadButtonId__5,
    label: "Link 2",
    href: "#/navigation/key-pad-menu",
    isSelected: selectedID === keypadButtonId__5,
    onClick: function onClick() {
      return setSelectedID(keypadButtonId__5);
    }
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "link",
    size: "l"
  })), (0, _react2.jsx)(_key_pad_menu_item.EuiKeyPadMenuItem, {
    "data-test-subj": "cy-keypad-link-3",
    id: keypadButtonId__6,
    label: "Disabled Link 3",
    isDisabled: true,
    isSelected: selectedID === keypadButtonId__6
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "link",
    size: "l"
  }))));
};
beforeEach(function () {
  cy.realMount((0, _react2.jsx)(KeyPadMenu, null));
  cy.get('div[aria-label="Menu keypad"]').should('exist');
});
describe('EuiKeyPadMenu', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations on item click', function () {
      cy.get('a[data-test-subj="cy-keypad-link-2"]').realClick();
      cy.get('a[data-test-subj="cy-keypad-link-2"]').should('have.attr', 'aria-current', 'true');
      cy.checkAxe();
    });
    it('has zero violations on item keypress', function () {
      cy.repeatRealPress('Tab', 3);
      cy.get('button[data-test-subj="cy-keypad-button-3"]').should('have.focus');
      cy.realPress('Space');
      cy.get('button[data-test-subj="cy-keypad-button-3"]').should('have.attr', 'aria-pressed', 'true');
      cy.checkAxe();
      cy.realPress(['Shift', 'Tab']);
      cy.get('button[data-test-subj="cy-keypad-button-2"]').should('have.attr', 'aria-pressed', 'false');
      cy.realPress('Space');
      cy.get('button[data-test-subj="cy-keypad-button-2"]').invoke('attr', 'aria-pressed').should('equal', 'true');
      cy.get('button[data-test-subj="cy-keypad-button-3"]').invoke('attr', 'aria-pressed').should('equal', 'false');
      cy.checkAxe();
    });
  });
});