"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScopedWorkflowServiceImpl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Workflow service scoped to a given user/request.
 */

class ScopedWorkflowServiceImpl {
  constructor({
    client,
    registry
  }) {
    (0, _defineProperty2.default)(this, "client", void 0);
    (0, _defineProperty2.default)(this, "registry", void 0);
    this.client = client;
    this.registry = registry;
  }
  async get(id) {
    if (this.registry.has(id)) {
      return this.registry.get(id);
    }
    return this.client.get({
      workflowId: id
    });
  }
}
exports.ScopedWorkflowServiceImpl = ScopedWorkflowServiceImpl;