"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowClientImpl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _workflow = require("../../saved_objects/workflow");
var _utils = require("../utils");
var _converters = require("./converters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Client to interact with the workflow saved objects.
 */

class WorkflowClientImpl {
  constructor({
    client,
    user,
    logger
  }) {
    (0, _defineProperty2.default)(this, "client", void 0);
    (0, _defineProperty2.default)(this, "user", void 0);
    // @ts-expect-error will be used at some point
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.client = client;
    this.user = user;
    this.logger = logger;
  }
  async list(options = {}) {
    const builder = (0, _utils.createBuilder)(_workflow.workflowSoTypeName);
    const filter = builder.and(builder.equals('user_id', this.user.id), ...(options.category ? [builder.equals('categories', options.category)] : [])).toKQL();
    const {
      saved_objects: results
    } = await this.client.find({
      type: _workflow.workflowSoTypeName,
      filter,
      perPage: 1000
    });
    return results.map(_converters.savedObjectToModel);
  }
  async get({
    workflowId
  }) {
    const workflowSo = await this._rawGet({
      workflowId
    });
    return (0, _converters.savedObjectToModel)(workflowSo);
  }
  async _rawGet({
    workflowId
  }) {
    const builder = (0, _utils.createBuilder)(_workflow.workflowSoTypeName);
    const filter = builder.and(builder.equals('user_id', this.user.id), builder.equals('workflow_id', workflowId)).toKQL();
    const {
      saved_objects: results
    } = await this.client.find({
      type: _workflow.workflowSoTypeName,
      filter
    });
    if (results.length > 0) {
      return results[0];
    }
    throw new Error(`Workflow ${workflowId} not found`);
  }
}
exports.WorkflowClientImpl = WorkflowClientImpl;