"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInternalRunner = void 0;
var _run_node = require("./run_node");
var _run_workflow = require("./run_workflow");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createInternalRunner = ({
  internalContext
}) => {
  const contextWithInjectedRunner = {
    ...internalContext,
    // using a stub implementation, will replace once the runner is created
    getRunner: () => {
      if (!runner) {
        throw new Error('accessing runner before end of init phase');
      }
      return runner;
    }
  };
  const runNode = (0, _run_node.createNodeRunner)({
    internalContext: contextWithInjectedRunner
  });
  const runWorkflow = (0, _run_workflow.createWorkflowRunner)({
    internalContext: contextWithInjectedRunner
  });
  const runner = {
    runNode,
    runWorkflow
  };
  return runner;
};
exports.createInternalRunner = createInternalRunner;