"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMockProvider = exports.createMockFactoryServices = void 0;
var _loggingMocks = require("@kbn/logging-mocks");
var _mocks = require("@kbn/core/server/mocks");
var _tools = require("./tools");
var _models = require("./models");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createMockProvider = () => {
  return {
    has: jest.fn(),
    get: jest.fn(),
    getAll: jest.fn(),
    getAllKeys: jest.fn()
  };
};
exports.createMockProvider = createMockProvider;
const createScopedRunnerMock = () => {
  return {
    runWorkflow: jest.fn(),
    runNode: jest.fn()
  };
};
const createMockFactoryServices = () => {
  const logger = _loggingMocks.loggerMock.create();
  const modelProvider = (0, _models.createModelProviderMock)();
  const workflowRunner = createScopedRunnerMock();
  const toolProvider = (0, _tools.createToolProviderMock)();
  const esClusterClient = _mocks.elasticsearchServiceMock.createScopedClusterClient();
  const nodeRegistry = createMockProvider();
  const workflowRegistry = createMockProvider();
  return {
    logger,
    modelProvider,
    workflowRunner,
    toolProvider,
    esClusterClient,
    nodeRegistry,
    workflowRegistry
  };
};
exports.createMockFactoryServices = createMockFactoryServices;