"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createModelProviderFactory = void 0;
var _wcGenaiUtils = require("@kbn/wc-genai-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Utility HOF function to bind the dependencies to create a {@link ModelProviderFactory}.
 */
const createModelProviderFactory = ({
  inference,
  actions
}) => async ({
  request,
  defaultConnectorId
}) => {
  let connectorId = defaultConnectorId;
  if (!connectorId) {
    const connectors = await (0, _wcGenaiUtils.getConnectorList)({
      actions,
      request
    });
    const defaultConnector = (0, _wcGenaiUtils.getDefaultConnector)({
      connectors
    });
    connectorId = defaultConnector.connectorId;
  }
  const chatModel = await inference.getChatModel({
    request,
    connectorId,
    chatModelOptions: {}
  });
  return {
    getDefaultModel: () => chatModel
  };
};
exports.createModelProviderFactory = createModelProviderFactory;