"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCalculatorTool = void 0;
var _zod = require("@kbn/zod");
var _exprEval = require("expr-eval");
var _wcFrameworkTypesCommon = require("@kbn/wc-framework-types-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCalculatorTool = () => {
  return {
    id: _wcFrameworkTypesCommon.BuiltInToolId.calculator,
    name: 'calculator',
    description: `
    Useful for getting the result of a math expression.
    The input should be a valid mathematical expression that could be executed by a simple calculator.

    Examples:
    - 125 * (5 + 19)
    - 4 - 12^3
    `,
    schema: {
      input: _zod.z.string().describe('the expression to evaluate')
    },
    handler: async ({
      input
    }) => {
      try {
        return _exprEval.Parser.evaluate(input).toString();
      } catch (e) {
        throw new Error(`Error evaluating expression: ${e.message}`);
      }
    }
  };
};
exports.getCalculatorTool = getCalculatorTool;