"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getToolExecutionNodeTypeDefinition = void 0;
var _wcFrameworkTypesCommon = require("@kbn/wc-framework-types-common");
var _wcFrameworkTypesServer = require("@kbn/wc-framework-types-server");
var _state = require("../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getToolExecutionNodeTypeDefinition = () => {
  return {
    id: _wcFrameworkTypesCommon.NodeType.toolExecution,
    name: 'Tool execution',
    description: 'Execute a tool with predefined or dynamic parameters',
    factory: context => {
      return {
        run: async ({
          input,
          state,
          executionState
        }) => {
          const {
            services: {
              toolProvider
            }
          } = context;
          const interpolatedInput = (0, _state.interpolateValue)(input, state);
          const {
            toolId,
            toolArguments,
            parseResponse,
            output
          } = interpolatedInput;
          if (!(await toolProvider.has(toolId))) {
            throw new _wcFrameworkTypesServer.WorkflowExecutionError(`Tool with id [${toolId}] not found`, 'toolNotFound', {
              state: executionState
            });
          }
          const tool = await toolProvider.get(toolId);
          let toolResult = await tool.handler(toolArguments);
          if (parseResponse && typeof toolResult === 'string') {
            toolResult = JSON.parse(toolResult);
          }
          state.set(output, toolResult);
        }
      };
    }
  };
};
exports.getToolExecutionNodeTypeDefinition = getToolExecutionNodeTypeDefinition;