"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPromptNodeTypeDefinition = void 0;
var _wcFrameworkTypesCommon = require("@kbn/wc-framework-types-common");
var _state = require("../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPromptNodeTypeDefinition = () => {
  return {
    id: _wcFrameworkTypesCommon.NodeType.prompt,
    name: 'Prompt',
    description: 'Execute a prompt against an LLM and output the result.',
    factory: context => {
      return {
        run: async ({
          input,
          state
        }) => {
          const {
            services: {
              modelProvider
            }
          } = context;

          // TODO: structuredOutput option

          const interpolatedInput = (0, _state.interpolateValue)(input, state);
          const {
            prompt,
            output
          } = interpolatedInput;
          const model = modelProvider.getDefaultModel();
          const response = await model.invoke(prompt);
          state.set(output, response.content);
        }
      };
    }
  };
};
exports.getPromptNodeTypeDefinition = getPromptNodeTypeDefinition;