"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkChatAppPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _features = require("./features");
var _saved_objects = require("./saved_objects");
var _services = require("./services");
var _routes = require("./routes");
var _builtin = require("./services/runner/builtin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class WorkChatAppPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "setupServices", void 0);
    (0, _defineProperty2.default)(this, "startServices", void 0);
    this.logger = context.logger;
    this.config = context.config.get();
  }
  setup(core, setupDeps) {
    this.setupServices = (0, _services.createSetupServices)();
    (0, _saved_objects.registerTypes)({
      savedObjects: core.savedObjects
    });
    (0, _features.registerFeatures)({
      features: setupDeps.features
    });
    const router = core.http.createRouter();
    (0, _routes.registerRoutes)({
      core,
      router,
      logger: this.logger.get(),
      getServices: () => this.startServices
    });
    (0, _builtin.registerBuiltInNodeTypes)({
      registry: this.setupServices.nodeRegistry
    });
    (0, _builtin.registerBuiltInTools)({
      registry: this.setupServices.toolRegistry
    });
    return {
      tools: {
        register: tool => {
          return this.setupServices.toolRegistry.register(tool);
        }
      },
      workflows: {
        register: definition => {
          return this.setupServices.workflowRegistry.register(definition);
        }
      }
    };
  }
  start(core, pluginsDependencies) {
    this.startServices = (0, _services.createStartServices)({
      core,
      config: this.config,
      logger: this.logger,
      pluginsDependencies,
      setupServices: this.setupServices
    });
    return {
      workflows: {
        run: args => {
          return this.startServices.workflowRunner.run(args);
        }
      }
    };
  }
}
exports.WorkChatAppPlugin = WorkChatAppPlugin;