"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messageFromLangchain = exports.extractTextContent = void 0;
var _messages = require("@langchain/core/messages");
var _utils = require("../../../utils");
var _conversation_events = require("../../../../common/conversation_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const messageFromLangchain = message => {
  if ((0, _messages.isAIMessage)(message)) {
    var _message$tool_calls$m, _message$tool_calls;
    const toolCalls = (_message$tool_calls$m = (_message$tool_calls = message.tool_calls) === null || _message$tool_calls === void 0 ? void 0 : _message$tool_calls.map(convertLangchainToolCall)) !== null && _message$tool_calls$m !== void 0 ? _message$tool_calls$m : [];
    return (0, _conversation_events.createAssistantMessage)({
      id: message.id,
      content: extractTextContent(message),
      toolCalls
    });
  }
  if ((0, _messages.isHumanMessage)(message)) {
    return (0, _conversation_events.createUserMessage)({
      id: message.id,
      content: extractTextContent(message)
    });
  }

  // tools will come later
  throw new Error(`Unsupported message type ${message}`);
};
exports.messageFromLangchain = messageFromLangchain;
const convertLangchainToolCall = toolCall => {
  _utils.AppLogger.getInstance().debug(`Calling tool: ${toolCall.name} with args: ${JSON.stringify(toolCall.args)}`);
  return {
    toolCallId: toolCall.id,
    // TODO: figure out a default, e.g {messageId}_{callIndex}
    toolName: toolCall.name,
    args: toolCall.args
  };
};
const extractTextContent = message => {
  if (typeof message.content === 'string') {
    return message.content;
  } else {
    let content = '';
    for (const item of message.content) {
      if (item.type === 'text') {
        content += item.text;
      }
    }
    return content;
  }
};
exports.extractTextContent = extractTextContent;