"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withSystemPrompt = void 0;
var _prompts = require("@langchain/core/prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSystemPrompt = agentPrompt => {
  return `You are a helpful chat assistant from the Elasticsearch company.

  You have tools at your disposal that you can use to answer the user's question.
  E.g. when available and relevant, use the search docs tool to search the knowledge base for relevant documents.

  ### Specific agent instructions

  ${agentPrompt}

  ### Additional info
  - The current date is: ${new Date().toISOString()}
  - You can use markdown format to structure your response
  `;
};
const withSystemPrompt = async ({
  agentPrompt,
  messages
}) => {
  return await _prompts.ChatPromptTemplate.fromMessages([['system', getSystemPrompt(agentPrompt)], ['placeholder', '{messages}']]).invoke({
    messages
  });
};
exports.withSystemPrompt = withSystemPrompt;