"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSimpleGraphConverter = void 0;
var _utils = require("../../utils");
var _utils2 = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns a converter that will handle events for "simple" type of graph (base non-composite graphs).
 */
const getSimpleGraphConverter = ({
  graphName
}) => {
  const handleEvent = event => {
    return (0, _utils2.matchGraphName)(event, graphName);
  };
  const convert = event => {
    // stream text chunks for the UI
    if (event.event === 'on_chat_model_stream') {
      const chunk = event.data.chunk;
      const content = (0, _utils.extractTextContent)(chunk);
      if (content) {
        var _chunk$id;
        return [{
          type: 'message_chunk',
          content_chunk: content,
          message_id: (_chunk$id = chunk.id) !== null && _chunk$id !== void 0 ? _chunk$id : event.run_id
        }];
      }
    }

    // emit full message on each agent step
    if (event.event === 'on_chain_end' && event.name === 'agent') {
      var _event$data$output$ad;
      const addedMessages = (_event$data$output$ad = event.data.output.addedMessages) !== null && _event$data$output$ad !== void 0 ? _event$data$output$ad : [];
      const lastMessage = addedMessages[addedMessages.length - 1];
      const message = (0, _utils.messageFromLangchain)(lastMessage);

      // we know it can't be a user message given it's the LLM response
      const citations = event.data.input.citations;
      message.citations = citations;
      return [{
        type: 'message',
        message
      }];
    }

    // emit tool result events
    if (event.event === 'on_chain_end' && event.name === 'tools') {
      var _event$data$output$ad2;
      const toolMessages = (_event$data$output$ad2 = event.data.output.addedMessages) !== null && _event$data$output$ad2 !== void 0 ? _event$data$output$ad2 : [];
      const toolResultEvents = [];
      for (const toolMessage of toolMessages) {
        toolResultEvents.push({
          type: 'tool_result',
          toolResult: {
            callId: toolMessage.tool_call_id,
            result: (0, _utils.extractTextContent)(toolMessage)
          }
        });
      }
      return toolResultEvents;
    }
    return [];
  };
  return {
    handleEvent,
    convert
  };
};
exports.getSimpleGraphConverter = getSimpleGraphConverter;