"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSearchAgentGraphConverter = void 0;
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns a converter that will handle events for the search agent graph.
 */
const getSearchAgentGraphConverter = ({
  graphName
}) => {
  const handleEvent = event => {
    return (0, _utils.matchGraphName)(event, graphName);
  };
  const convert = event => {
    if (isChainStartWithName(event, 'create_planning')) {
      return [createProgressionEvent('planning')];
    }
    if (isChainStartWithName(event, 'retrieve_agent')) {
      return [createProgressionEvent('retrieval')];
    }
    if (isChainStartWithName(event, 'rate_results')) {
      return [createProgressionEvent('analysis')];
    }
    if (isChainStartWithName(event, 'generate_summary')) {
      return [createProgressionEvent('generate_summary')];
    }
    return [];
  };
  return {
    handleEvent,
    convert
  };
};
exports.getSearchAgentGraphConverter = getSearchAgentGraphConverter;
const createProgressionEvent = step => ({
  type: 'progression',
  progressionType: 'research',
  data: {
    step
  }
});
const isChainStartWithName = (event, name) => {
  return event.event === 'on_chain_start' && event.name === name;
};