"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertGraphEvents = void 0;
var _rxjs = require("rxjs");
var _build_events_converter = require("./build_events_converter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function filterMap(project) {
  return (0, _rxjs.mergeMap)(value => {
    const result = project(value);
    return (0, _rxjs.of)(...result);
  });
}
const convertGraphEvents = () => {
  const eventConverter = (0, _build_events_converter.buildEventsConverter)();
  return langchain$ => {
    return langchain$.pipe(filterMap(eventConverter));
  };
};
exports.convertGraphEvents = convertGraphEvents;