"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBaseToolProvider = void 0;
var _wciServer = require("@kbn/wci-server");
var _constants = require("../../../../common/constants");
var _calculator = require("./calculator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBaseToolProvider = async () => {
  const tools = [(0, _calculator.getCalculatorTool)()];
  const server = (0, _wciServer.createMcpServer)({
    name: _constants.baseToolsProviderId,
    version: '1.0.0',
    tools
  });
  return {
    id: _constants.baseToolsProviderId,
    connect: (0, _wciServer.getConnectToInternalServer)({
      server,
      clientName: 'baseToolsClient'
    }),
    meta: {
      builtin: true
    }
  };
};
exports.getBaseToolProvider = getBaseToolProvider;